/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator;

import java.io.File;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.bpmnengine.BpmnEngineFactory;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.Scenario;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutomatorAPI {
    static Logger logger = LoggerFactory.getLogger(AutomatorAPI.class);
    @Autowired
    ServiceAccess serviceAccess;

    public Scenario createScenario() {
        return new Scenario();
    }

    public Scenario loadFromFile(File scenarioFile) throws AutomatorException {
        return Scenario.createFromFile(scenarioFile);
    }

    public BpmnEngine getBpmnEngineFromScenario(Scenario scenario, ConfigurationBpmEngine engineConfiguration) throws AutomatorException {
        try {
            if (scenario.getServerName() != null) {
                return this.getBpmnEngine(engineConfiguration, engineConfiguration.getByServerName(scenario.getServerName()));
            }
            if (scenario.getServerType() != null) {
                return this.getBpmnEngine(engineConfiguration, engineConfiguration.getByServerType(scenario.getServerType()));
            }
            return null;
        }
        catch (AutomatorException e) {
            logger.error("Can't connect the engine for the scenario [{}] serverName[{}] serverType[{}] : {}", new Object[]{scenario.getName(), scenario.getServerName(), scenario.getServerType(), e.getMessage()});
            throw e;
        }
    }

    public RunResult executeScenario(BpmnEngine bpmnEngine, RunParameters runParameters, Scenario scenario) {
        RunScenario runScenario = null;
        try {
            runScenario = new RunScenario(scenario, bpmnEngine, runParameters, this.serviceAccess);
        }
        catch (Exception e) {
            RunResult result = new RunResult(runScenario);
            result.addError(null, "Initialization error");
            return result;
        }
        RunResult runResult = new RunResult(runScenario);
        runResult.add(runScenario.runScenario());
        return runResult;
    }

    public BpmnEngine getBpmnEngine(ConfigurationBpmEngine engineConfiguration, ConfigurationBpmEngine.BpmnServerDefinition serverDefinition) throws AutomatorException {
        return BpmnEngineFactory.getInstance().getEngineFromConfiguration(engineConfiguration, serverDefinition);
    }

    public RunResult deployProcess(BpmnEngine bpmnEngine, RunParameters runParameters, Scenario scenario) {
        RunScenario runScenario = null;
        try {
            long begin = System.currentTimeMillis();
            runScenario = new RunScenario(scenario, bpmnEngine, runParameters, this.serviceAccess);
            RunResult runResult = new RunResult(runScenario);
            runResult.add(runScenario.runDeployment());
            runResult.addTimeExecution(System.currentTimeMillis() - begin);
            return runResult;
        }
        catch (Exception e) {
            RunResult result = new RunResult(runScenario);
            result.addError(null, "Process deployment error error " + e.getMessage());
            return result;
        }
    }
}

