/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine;

import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.bpmnengine.camunda7.BpmnEngineCamunda7;
import org.camunda.automator.bpmnengine.camunda8.BpmnEngineCamunda8;
import org.camunda.automator.bpmnengine.dummy.BpmnEngineDummy;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.engine.AutomatorException;

public class BpmnEngineFactory {
    public static BpmnEngineFactory getInstance() {
        return new BpmnEngineFactory();
    }

    public BpmnEngine getEngineFromConfiguration(ConfigurationBpmEngine engineConfiguration, ConfigurationBpmEngine.BpmnServerDefinition serverDefinition) throws AutomatorException {
        BpmnEngine engine = switch (serverDefinition.serverType) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationBpmEngine.CamundaEngine.CAMUNDA_7 -> new BpmnEngineCamunda7(engineConfiguration, serverDefinition);
            case ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8 -> new BpmnEngineCamunda8(engineConfiguration, serverDefinition);
            case ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8_SAAS -> new BpmnEngineCamunda8(engineConfiguration, serverDefinition);
            case ConfigurationBpmEngine.CamundaEngine.DUMMY -> new BpmnEngineDummy(engineConfiguration);
        };
        engine.init();
        return engine;
    }
}

