/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine.camunda7;

import io.camunda.operate.search.DateFilter;
import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.ScenarioDeployment;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.flow.FixedBackoffSupplier;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.backoff.BackoffStrategy;
import org.camunda.bpm.client.backoff.ExponentialBackoffStrategy;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.community.rest.client.api.DeploymentApi;
import org.camunda.community.rest.client.api.EngineApi;
import org.camunda.community.rest.client.api.ExternalTaskApi;
import org.camunda.community.rest.client.api.ProcessDefinitionApi;
import org.camunda.community.rest.client.api.ProcessInstanceApi;
import org.camunda.community.rest.client.api.TaskApi;
import org.camunda.community.rest.client.api.VariableInstanceApi;
import org.camunda.community.rest.client.dto.CompleteExternalTaskDto;
import org.camunda.community.rest.client.dto.CompleteTaskDto;
import org.camunda.community.rest.client.dto.DeploymentWithDefinitionsDto;
import org.camunda.community.rest.client.dto.ExternalTaskDto;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDto;
import org.camunda.community.rest.client.dto.LockExternalTaskDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDtoSorting;
import org.camunda.community.rest.client.dto.ProcessInstanceWithVariablesDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceDto;
import org.camunda.community.rest.client.dto.TaskDto;
import org.camunda.community.rest.client.dto.TaskQueryDto;
import org.camunda.community.rest.client.dto.TaskQueryDtoSorting;
import org.camunda.community.rest.client.dto.UserIdDto;
import org.camunda.community.rest.client.dto.VariableInstanceDto;
import org.camunda.community.rest.client.dto.VariableInstanceQueryDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnEngineCamunda7
implements BpmnEngine {
    private final Logger logger = LoggerFactory.getLogger(BpmnEngineCamunda7.class);
    private final String serverUrl;
    private final String userName;
    private final String password;
    private final int workerMaxJobsActive;
    private final boolean logDebug;
    public static final int SEARCH_MAX_SIZE = 100;
    ApiClient apiClient = null;
    ProcessDefinitionApi processDefinitionApi;
    TaskApi taskApi;
    ExternalTaskApi externalTaskApi;
    ProcessInstanceApi processInstanceApi;
    VariableInstanceApi variableInstanceApi;
    DeploymentApi deploymentApi;
    EngineApi engineApi;
    private int count = 0;

    public BpmnEngineCamunda7(ConfigurationBpmEngine engineConfiguration, ConfigurationBpmEngine.BpmnServerDefinition serverDefinition) {
        this.serverUrl = serverDefinition.camunda7ServerUrl;
        this.userName = serverDefinition.camunda7UserName;
        this.password = serverDefinition.camunda7Password;
        this.workerMaxJobsActive = serverDefinition.workerMaxJobsActive;
        this.logDebug = engineConfiguration.logDebug;
        this.init();
    }

    public BpmnEngineCamunda7(String serverUrl, String userName, String password, boolean logDebug) {
        this.serverUrl = serverUrl;
        this.userName = userName;
        this.password = password;
        this.workerMaxJobsActive = 1;
        this.logDebug = logDebug;
        this.init();
    }

    @Override
    public void init() {
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(this.serverUrl);
        if (!this.userName.trim().isEmpty()) {
            this.apiClient.setUsername(this.userName);
            this.apiClient.setPassword(this.password);
        }
        this.processDefinitionApi = new ProcessDefinitionApi(this.apiClient);
        this.taskApi = new TaskApi(this.apiClient);
        this.externalTaskApi = new ExternalTaskApi(this.apiClient);
        this.processInstanceApi = new ProcessInstanceApi(this.apiClient);
        this.variableInstanceApi = new VariableInstanceApi(this.apiClient);
        this.deploymentApi = new DeploymentApi(this.apiClient);
        this.engineApi = new EngineApi(this.apiClient);
    }

    @Override
    public void connection() throws AutomatorException {
        ++this.count;
        if (this.count > 2) {
            return;
        }
        try {
            this.engineApi.getProcessEngineNames();
            this.logger.info("Connection successfully to Camunda7 [{}] ", (Object)this.apiClient.getBasePath());
        }
        catch (ApiException e) {
            this.logger.error("Can't connect Camunda7 server[{}] User[{}]: {}", new Object[]{this.apiClient.getBasePath(), this.userName, e.toString()});
            throw new AutomatorException("Can't connect to Camunda7 [" + this.apiClient.getBasePath() + "] : " + e.toString());
        }
    }

    @Override
    public void disconnection() throws AutomatorException {
    }

    @Override
    public boolean isReady() {
        if (this.count > 2) {
            return true;
        }
        try {
            this.engineApi.getProcessEngineNames();
        }
        catch (ApiException e) {
            return false;
        }
        return true;
    }

    @Override
    public String createProcessInstance(String processId, String starterEventId, Map<String, Object> variables) throws AutomatorException {
        if (this.logDebug) {
            this.logger.info("BpmnEngine7.CreateProcessInstance: Process[" + processId + "] StartEvent[" + starterEventId + "]");
        }
        String dateString = this.dateToString(new Date());
        HashMap<String, VariableValueDto> variablesApi = new HashMap<String, VariableValueDto>();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            variablesApi.put(entry.getKey(), new VariableValueDto().value(entry.getValue()));
        }
        try {
            ProcessInstanceWithVariablesDto processInstanceDto = this.processDefinitionApi.startProcessInstanceByKey(processId, new StartProcessInstanceDto().variables(variablesApi).businessKey(dateString));
            return processInstanceDto.getId();
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't create process instance in [" + processId + "] StartEvent[" + starterEventId + "]", e);
        }
    }

    @Override
    public void endProcessInstance(String processInstanceId, boolean cleanAll) throws AutomatorException {
    }

    @Override
    public List<String> searchUserTasks(String processInstanceId, String userTaskId, int maxResult) throws AutomatorException {
        if (this.logDebug) {
            this.logger.info("BpmnEngine7.searchForActivity: Process[" + processInstanceId + "] taskName[" + userTaskId + "]");
        }
        List<String> listProcessInstance = this.getListSubProcessInstance(processInstanceId);
        TaskQueryDto taskQueryDto = new TaskQueryDto();
        taskQueryDto.addProcessInstanceIdInItem(processInstanceId);
        for (String subProcessInstance : listProcessInstance) {
            taskQueryDto.addProcessInstanceIdInItem(subProcessInstance);
        }
        taskQueryDto.addTaskDefinitionKeyInItem(userTaskId);
        List taskDtos = null;
        try {
            taskDtos = this.taskApi.queryTasks(Integer.valueOf(0), Integer.valueOf(maxResult), taskQueryDto);
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't searchTask", e);
        }
        return taskDtos.stream().map(TaskDto::getId).toList();
    }

    @Override
    public void executeUserTask(String userTaskId, String userId, Map<String, Object> variables) throws AutomatorException {
        if (this.logDebug) {
            this.logger.info("BpmnEngine7.executeUserTask: activityId[" + userTaskId + "]");
        }
        try {
            UserIdDto userIdDto = new UserIdDto();
            userIdDto.setUserId(userId == null ? "automator" : userId);
            this.taskApi.claim(userTaskId, userIdDto);
            HashMap<String, VariableValueDto> variablesApi = new HashMap<String, VariableValueDto>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                variablesApi.put(entry.getKey(), new VariableValueDto().value(entry.getValue()));
            }
            this.taskApi.complete(userTaskId, new CompleteTaskDto().variables(variablesApi));
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't execute taskId[" + userTaskId + "] with userId[" + userId + "]", e);
        }
    }

    @Override
    public BpmnEngine.RegisteredTask registerServiceTask(String workerId, String topic, Duration lockTime, Object jobHandler, FixedBackoffSupplier backoffSupplier) {
        if (!(jobHandler instanceof ExternalTaskHandler)) {
            this.logger.error("handler is not a externalTaskHandler implementation, can't register the worker [{}], topic [{}]", (Object)workerId, (Object)topic);
            return null;
        }
        BpmnEngine.RegisteredTask registeredTask = new BpmnEngine.RegisteredTask();
        ExternalTaskClient client = ExternalTaskClient.create().baseUrl(this.serverUrl).workerId(workerId).maxTasks(this.workerMaxJobsActive < 1 ? 1 : this.workerMaxJobsActive).lockDuration(lockTime.toMillis()).asyncResponseTimeout(20000L).backoffStrategy((BackoffStrategy)new ExponentialBackoffStrategy()).build();
        registeredTask.topicSubscription = client.subscribe(topic).lockDuration(10000L).handler((ExternalTaskHandler)jobHandler).open();
        return registeredTask;
    }

    @Override
    public List<String> searchServiceTasks(String processInstanceId, String serviceTaskId, String topic, int maxResult) throws AutomatorException {
        List taskDtos;
        if (this.logDebug) {
            this.logger.info("BpmnEngine7.searchForActivity: Process[" + processInstanceId + "] taskName[" + serviceTaskId + "]");
        }
        List<String> listProcessInstance = this.getListSubProcessInstance(processInstanceId);
        ExternalTaskQueryDto externalTaskQueryDto = new ExternalTaskQueryDto();
        externalTaskQueryDto.addProcessInstanceIdInItem(processInstanceId);
        for (String subProcessInstance : listProcessInstance) {
            externalTaskQueryDto.addProcessInstanceIdInItem(subProcessInstance);
        }
        externalTaskQueryDto.activityId(serviceTaskId);
        try {
            taskDtos = this.externalTaskApi.queryExternalTasks(Integer.valueOf(0), Integer.valueOf(100), externalTaskQueryDto);
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't searchTask", e);
        }
        return taskDtos.stream().map(ExternalTaskDto::getId).toList();
    }

    @Override
    public void executeServiceTask(String serviceTaskId, String userId, Map<String, Object> variables) throws AutomatorException {
        if (this.logDebug) {
            this.logger.info("BpmnEngine7.executeUserTask: activityId[" + serviceTaskId + "]");
        }
        try {
            String workerId = this.getUniqWorkerId();
            this.externalTaskApi.lock(serviceTaskId, new LockExternalTaskDto().workerId(workerId).lockDuration(Long.valueOf(10000L)));
            HashMap<String, VariableValueDto> variablesApi = new HashMap<String, VariableValueDto>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                variablesApi.put(entry.getKey(), new VariableValueDto().value(entry.getValue()));
            }
            ExternalCallBack externalCallBack = new ExternalCallBack();
            this.externalTaskApi.completeExternalTaskResourceAsync(serviceTaskId, new CompleteExternalTaskDto().variables(variablesApi).workerId(workerId), (ApiCallback)externalCallBack);
            int counter = 0;
            while (ExternalCallBack.STATUS.WAIT.equals((Object)externalCallBack.status) && counter < 200) {
                ++counter;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!ExternalCallBack.STATUS.SUCCESS.equals((Object)externalCallBack.status)) {
                throw new AutomatorException("Can't execute taskId[" + serviceTaskId + "] - answer[" + externalCallBack.status + "]");
            }
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't execute taskId[" + serviceTaskId + "] with userId[" + userId + "]", e);
        }
    }

    @Override
    public List<BpmnEngine.TaskDescription> searchTasksByProcessInstanceId(String processInstanceId, String taskId, int maxResult) throws AutomatorException {
        List<String> listProcessInstance = this.getListSubProcessInstance(processInstanceId);
        TaskQueryDto taskQueryDto = new TaskQueryDto();
        taskQueryDto.addProcessInstanceIdInItem(processInstanceId);
        for (String subProcessInstance : listProcessInstance) {
            taskQueryDto.addProcessInstanceIdInItem(subProcessInstance);
        }
        taskQueryDto.addTaskDefinitionKeyInItem(taskId);
        List taskDtos = null;
        try {
            taskDtos = this.taskApi.queryTasks(Integer.valueOf(0), Integer.valueOf(maxResult), taskQueryDto);
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't searchTask", e);
        }
        return taskDtos.stream().map(t -> {
            BpmnEngine.TaskDescription taskDescription = new BpmnEngine.TaskDescription();
            taskDescription.taskId = t.getName();
            taskDescription.type = ScenarioStep.Step.USERTASK;
            taskDescription.isCompleted = true;
            return taskDescription;
        }).toList();
    }

    @Override
    public List<BpmnEngine.ProcessDescription> searchProcessInstanceByVariable(String processId, Map<String, Object> filterVariables, int maxResult) throws AutomatorException {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getVariables(String processInstanceId) throws AutomatorException {
        VariableInstanceQueryDto variableQuery = new VariableInstanceQueryDto();
        variableQuery.processInstanceIdIn(List.of(processInstanceId));
        try {
            List variableInstanceDtos = this.variableInstanceApi.queryVariableInstances(Integer.valueOf(0), Integer.valueOf(1000), Boolean.valueOf(true), variableQuery);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (VariableInstanceDto variable : variableInstanceDtos) {
                variables.put(variable.getName(), variable.getValue());
            }
            return variables;
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't searchVariables", e);
        }
    }

    @Override
    public long countNumberOfProcessInstancesCreated(String processName, DateFilter startDate, DateFilter endDate) throws AutomatorException {
        try {
            List processInstanceDtos;
            int cumul = 0;
            ProcessInstanceQueryDto processInstanceQuery = new ProcessInstanceQueryDto();
            processInstanceQuery = processInstanceQuery.addProcessDefinitionKeyInItem(processName);
            processInstanceQuery.addSortingItem(new ProcessInstanceQueryDtoSorting().sortBy(ProcessInstanceQueryDtoSorting.SortByEnum.INSTANCEID).sortOrder(ProcessInstanceQueryDtoSorting.SortOrderEnum.ASC));
            int maxLoop = 0;
            int firstResult = 0;
            do {
                processInstanceDtos = this.processInstanceApi.queryProcessInstances(Integer.valueOf(firstResult), Integer.valueOf(100), processInstanceQuery);
                firstResult += processInstanceDtos.size();
                cumul = (int)((long)cumul + processInstanceDtos.stream().filter(t -> {
                    Date datePI = this.stringToDate(t.getBusinessKey());
                    if (datePI == null) {
                        return false;
                    }
                    return datePI.after(startDate.getDate());
                }).count());
            } while (processInstanceDtos.size() >= 100 && ++maxLoop < 1000);
            return cumul;
        }
        catch (Exception e) {
            throw new AutomatorException("Error during countNumberOfProcessInstancesCreated");
        }
    }

    @Override
    public long countNumberOfProcessInstancesEnded(String processName, DateFilter startDate, DateFilter endDate) throws AutomatorException {
        throw new AutomatorException("Not yet implemented");
    }

    @Override
    public long countNumberOfTasks(String processId, String taskId) throws AutomatorException {
        try {
            List taskDtos;
            int cumul = 0;
            TaskQueryDto taskQueryDto = new TaskQueryDto();
            taskQueryDto = taskQueryDto.addProcessDefinitionKeyInItem(processId);
            taskQueryDto.addSortingItem(new TaskQueryDtoSorting().sortBy(TaskQueryDtoSorting.SortByEnum.INSTANCEID).sortOrder(TaskQueryDtoSorting.SortOrderEnum.ASC));
            int maxLoop = 0;
            int firstResult = 0;
            do {
                taskDtos = this.taskApi.queryTasks(Integer.valueOf(firstResult), Integer.valueOf(100), taskQueryDto);
                firstResult += taskDtos.size();
                cumul += taskDtos.size();
            } while (taskDtos.size() >= 100 && ++maxLoop < 1000);
            return cumul;
        }
        catch (Exception e) {
            throw new AutomatorException("Error during countNumberOfTasks");
        }
    }

    @Override
    public String deployBpmn(File processFile, ScenarioDeployment.Policy policy) throws AutomatorException {
        try {
            DeploymentWithDefinitionsDto deploymentSource = this.deploymentApi.createDeployment(null, null, Boolean.valueOf(ScenarioDeployment.Policy.ONLYNOTEXIST.equals((Object)policy)), Boolean.TRUE, processFile.getName(), new Date(), processFile);
            return deploymentSource.getId();
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't deploy process ", e);
        }
    }

    @Override
    public ConfigurationBpmEngine.CamundaEngine getTypeCamundaEngine() {
        return ConfigurationBpmEngine.CamundaEngine.CAMUNDA_7;
    }

    @Override
    public String getSignature() {
        return ConfigurationBpmEngine.CamundaEngine.CAMUNDA_7 + " serverUrl[" + this.serverUrl + "]";
    }

    @Override
    public int getWorkerExecutionThreads() {
        return this.workerMaxJobsActive;
    }

    @Override
    public void turnHighFlowMode(boolean hightFlowMode) {
    }

    private String getUniqWorkerId() {
        return Thread.currentThread().getName() + "-" + System.currentTimeMillis();
    }

    private List<String> getListSubProcessInstance(String rootProcessInstance) throws AutomatorException {
        List processInstanceDtos;
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.superProcessInstance(rootProcessInstance);
        try {
            processInstanceDtos = this.processInstanceApi.queryProcessInstances(Integer.valueOf(0), Integer.valueOf(100000), processInstanceQueryDto);
        }
        catch (ApiException e) {
            throw new AutomatorException("Can't searchSubProcess", e);
        }
        return processInstanceDtos.stream().map(ProcessInstanceDto::getId).toList();
    }

    private String dateToString(Date date) {
        return String.valueOf(date.getTime());
    }

    private Date stringToDate(String dateSt) {
        if (dateSt == null) {
            return null;
        }
        return new Date(Long.valueOf(dateSt));
    }

    public static class ExternalCallBack
    implements ApiCallback {
        public STATUS status = STATUS.WAIT;
        public ApiException e;

        public void onFailure(ApiException e, int i, Map map) {
            this.status = STATUS.FAILURE;
            this.e = e;
        }

        public void onSuccess(Object o, int i, Map map) {
            this.status = STATUS.SUCCESS;
        }

        public void onUploadProgress(long l, long l1, boolean b) {
        }

        public void onDownloadProgress(long l, long l1, boolean b) {
        }

        public static enum STATUS {
            WAIT,
            FAILURE,
            SUCCESS;

        }
    }
}

