/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.definition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.ScenarioDeployment;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioFlowControl;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioWarmingUp;
import org.camunda.automator.engine.AutomatorException;

public class Scenario {
    private final List<ScenarioExecution> executions = new ArrayList<ScenarioExecution>();
    private final List<ScenarioDeployment> deployments = new ArrayList<ScenarioDeployment>();
    private final List<ScenarioStep> flows = new ArrayList<ScenarioStep>();
    private ScenarioWarmingUp warmingUp;
    private ScenarioFlowControl flowControl;
    private String name;
    private String version;
    private String processName;
    private String processId;
    private String modeVerification;
    private String serverName;
    private String serverType;
    private String scenarioFile = null;

    public static Scenario createFromJson(String jsonFile) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        Scenario scnHead = (Scenario)gson.fromJson(jsonFile, Scenario.class);
        scnHead.afterUnSerialize();
        return scnHead;
    }

    public static Scenario createFromFile(File scenarioFile) throws AutomatorException {
        Scenario scenario;
        BufferedReader br = new BufferedReader(new FileReader(scenarioFile));
        try {
            String st;
            StringBuilder jsonContent = new StringBuilder();
            while ((st = br.readLine()) != null) {
                jsonContent.append(st);
            }
            Scenario scnHead = Scenario.createFromJson(jsonContent.toString());
            scnHead.scenarioFile = scenarioFile.getAbsolutePath();
            scenario = scnHead;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new AutomatorException("Can't interpret JSON [" + scenarioFile.getAbsolutePath() + "] " + e.getMessage());
            }
        }
        br.close();
        return scenario;
    }

    public Scenario addExecution(ScenarioExecution scnExecution) {
        this.executions.add(scnExecution);
        return this;
    }

    public List<ScenarioExecution> getExecutions() {
        return this.executions;
    }

    public List<ScenarioStep> getFlows() {
        return this.flows;
    }

    public ScenarioWarmingUp getWarmingUp() {
        return this.warmingUp;
    }

    public ScenarioFlowControl getFlowControl() {
        return this.flowControl;
    }

    public List<ScenarioDeployment> getDeployments() {
        return this.deployments;
    }

    public String getName() {
        return this.name;
    }

    public Scenario setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Scenario setProcessId(String processId) {
        this.processId = processId;
        return this;
    }

    public File getScenarioFile() {
        return new File(this.scenarioFile);
    }

    public String getServerName() {
        if (this.serverName == null || this.serverName.isEmpty()) {
            return null;
        }
        return this.serverName;
    }

    public ConfigurationBpmEngine.CamundaEngine getServerType() {
        try {
            return ConfigurationBpmEngine.CamundaEngine.valueOf(this.serverType.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getModeVerification() {
        return this.modeVerification;
    }

    private void afterUnSerialize() {
        for (ScenarioExecution scnExecution : this.getExecutions()) {
            scnExecution.afterUnSerialize(this);
        }
    }
}

