/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.definition;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.engine.AutomatorException;

public class ScenarioStep {
    private final Map<String, String> variablesOperation = Collections.emptyMap();
    private final Integer nbWorkers = 1;
    private final Long fixedBackOffDelay = 0L;
    public String endWarmingUp;
    private ScenarioExecution scnExecution;
    private Step type;
    private String taskId;
    private String topic;
    private Map<String, Object> variables = Collections.emptyMap();
    private String userId;
    private String delay;
    private String waitingTime;
    private Integer numberOfExecutions;
    private String frequency;
    private String processId;
    private MODEEXECUTION modeExecution = MODEEXECUTION.WAIT;

    public ScenarioStep(ScenarioExecution scnExecution) {
        this.scnExecution = scnExecution;
    }

    public static ScenarioStep createStepCreate(ScenarioExecution scnExecution, String starterId) {
        ScenarioStep scenarioStep = new ScenarioStep(scnExecution);
        scenarioStep.type = Step.STARTEVENT;
        scenarioStep.taskId = starterId;
        return scenarioStep;
    }

    public static ScenarioStep createStepUserTask(ScenarioExecution scnExecution, String activityId) {
        ScenarioStep scenarioStep = new ScenarioStep(scnExecution);
        scenarioStep.type = Step.USERTASK;
        scenarioStep.taskId = activityId;
        return scenarioStep;
    }

    public Step getType() {
        return this.type;
    }

    public ScenarioStep setType(Step type) {
        this.type = type;
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public ScenarioStep setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public ScenarioStep setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public Map<String, String> getVariablesOperations() {
        return this.variablesOperation == null ? Collections.emptyMap() : this.variablesOperation;
    }

    public Map<String, Object> getVariables() {
        return this.variables == null ? Collections.emptyMap() : this.variables;
    }

    public ScenarioStep setVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public String getDelay() {
        return this.delay;
    }

    public ScenarioStep setDelay(String delay) {
        this.delay = delay;
        return this;
    }

    public String getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(String waitingTime) {
        this.waitingTime = waitingTime;
    }

    public Duration getWaitingTimeDuration(Duration defaultDuration) {
        try {
            return Duration.parse(this.waitingTime);
        }
        catch (Exception e) {
            return defaultDuration;
        }
    }

    public ScenarioExecution getScnExecution() {
        return this.scnExecution;
    }

    public void setScnExecution(ScenarioExecution scnExecution) {
        this.scnExecution = scnExecution;
    }

    public int getNumberOfExecutions() {
        return this.numberOfExecutions == null ? 1 : this.numberOfExecutions;
    }

    public void setNumberOfExecutions(int numberOfExecutions) {
        this.numberOfExecutions = numberOfExecutions;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public int getNbWorkers() {
        return this.nbWorkers == null || this.nbWorkers == 0 ? 1 : this.nbWorkers;
    }

    public String getProcessId() {
        return this.processId;
    }

    public long getFixedBackOffDelay() {
        return this.fixedBackOffDelay == null ? 0L : this.fixedBackOffDelay;
    }

    protected void afterUnSerialize(ScenarioExecution scnExecution) {
        this.scnExecution = scnExecution;
    }

    public void checkConsistence() throws AutomatorException {
        if (this.getTaskId() == null || this.getTaskId().trim().isEmpty()) {
            throw new AutomatorException("Step taskId is mandatory");
        }
        switch (this.type) {
            case SERVICETASK: {
                if (this.getTopic() != null && !this.getTopic().trim().isEmpty()) break;
                throw new AutomatorException("Step.SERVICETASK: " + this.getTaskId() + " topic is mandatory");
            }
        }
    }

    public String getEndWarmingUp() {
        return this.endWarmingUp;
    }

    public MODEEXECUTION getModeExecution() {
        return this.modeExecution == null ? MODEEXECUTION.WAIT : this.modeExecution;
    }

    public static enum MODEEXECUTION {
        WAIT,
        ASYNCHRONOUS,
        ASYNCHRONOUSLIMITED;

    }

    public static enum Step {
        STARTEVENT,
        USERTASK,
        SERVICETASK,
        MESSAGE,
        ENDEVENT,
        EXCLUSIVEGATEWAY,
        PARALLELGATEWAY;

    }
}

