/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.util.Collections;
import java.util.List;

public class RunParameters {
    public LOGLEVEL logLevel = LOGLEVEL.MONITORING;
    public int numberOfThreadsPerScenario = 10;
    public boolean execution = false;
    public boolean creation = true;
    public boolean servicetask = true;
    public boolean usertask = true;
    public boolean verification = false;
    public boolean clearAllAfter = false;
    public boolean deploymentProcess = true;
    public boolean fullDetailsSythesis = false;
    public List<String> filterServiceTask = Collections.emptyList();
    public boolean deepTracking = true;
    public String scenarioPath;
    public boolean warmingUp = true;

    public int getNumberOfThreadsPerScenario() {
        return this.numberOfThreadsPerScenario <= 0 ? 1 : this.numberOfThreadsPerScenario;
    }

    public boolean isLevelDebug() {
        return this.getLogLevelAsNumber() >= 4;
    }

    public boolean isLevelInfo() {
        return this.getLogLevelAsNumber() >= 3;
    }

    public boolean isLevelMonitoring() {
        return this.getLogLevelAsNumber() >= 2;
    }

    public void setFilterExecutionServiceTask(List<String> filterServiceTask) {
        this.filterServiceTask = filterServiceTask;
    }

    public boolean blockExecutionServiceTask(String topic) {
        if (this.filterServiceTask.isEmpty()) {
            return false;
        }
        return !this.filterServiceTask.contains(topic);
    }

    private int getLogLevelAsNumber() {
        switch (this.logLevel) {
            case NOTHING: {
                return 0;
            }
            case MAIN: {
                return 1;
            }
            case MONITORING: {
                return 2;
            }
            case INFO: {
                return 3;
            }
            case DEBUG: {
                return 4;
            }
        }
        return 0;
    }

    public static enum LOGLEVEL {
        DEBUG,
        INFO,
        MONITORING,
        MAIN,
        NOTHING;

    }
}

