/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.Scenario;
import org.camunda.automator.definition.ScenarioDeployment;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioTool;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenarioExecution;
import org.camunda.automator.engine.RunScenarioVerification;
import org.camunda.automator.engine.flow.RunScenarioFlows;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenario {
    private final Scenario scenario;
    private final BpmnEngine bpmnEngine;
    private final RunParameters runParameters;
    private final ServiceAccess serviceAccess;
    Logger logger = LoggerFactory.getLogger(RunScenario.class);

    public RunScenario(Scenario scenario, BpmnEngine bpmnEngine, RunParameters runParameters, ServiceAccess serviceAccess) {
        this.scenario = scenario;
        this.bpmnEngine = bpmnEngine;
        this.runParameters = runParameters;
        this.serviceAccess = serviceAccess;
    }

    public RunResult runScenario() {
        RunResult result = new RunResult(this);
        this.logger.info("RunScenario: ------ Deployment ({})", (Object)this.runParameters.deploymentProcess);
        if (this.runParameters.deploymentProcess) {
            result.add(this.runDeployment());
        }
        this.logger.info("RunScenario: ------ End deployment ");
        result.add(this.runExecutions());
        return result;
    }

    public RunResult runDeployment() {
        RunResult result = new RunResult(this);
        if (this.scenario.getDeployments() != null) {
            for (ScenarioDeployment deployment : this.scenario.getDeployments()) {
                boolean sameTypeServer = false;
                if (deployment.serverType.equals((Object)ConfigurationBpmEngine.CamundaEngine.CAMUNDA_7)) {
                    sameTypeServer = this.bpmnEngine.getTypeCamundaEngine().equals((Object)ConfigurationBpmEngine.CamundaEngine.CAMUNDA_7);
                } else if (deployment.serverType.equals((Object)ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8)) {
                    boolean bl = sameTypeServer = this.bpmnEngine.getTypeCamundaEngine().equals((Object)ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8) || this.bpmnEngine.getTypeCamundaEngine().equals((Object)ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8_SAAS);
                }
                if (sameTypeServer) {
                    try {
                        long begin = System.currentTimeMillis();
                        File processFile = ScenarioTool.loadFile(deployment.processFile, this);
                        this.logger.info("Deploy process[{}] on {}", (Object)processFile.getName(), (Object)this.bpmnEngine.getSignature());
                        result.addDeploymentProcessId(this.bpmnEngine.deployBpmn(processFile, deployment.policy));
                        result.addTimeExecution(System.currentTimeMillis() - begin);
                    }
                    catch (AutomatorException e) {
                        result.addError(null, "Can't deploy process [" + deployment.processFile + "] " + e.getMessage());
                    }
                    continue;
                }
                this.logger.info("RunScenario: can't Deploy ({}), not the same server", (Object)deployment.processFile);
            }
        }
        return result;
    }

    public RunResult runExecutions() {
        RunResult result = new RunResult(this);
        ExecutorService executor = Executors.newFixedThreadPool(this.runParameters.getNumberOfThreadsPerScenario());
        if (!this.scenario.getExecutions().isEmpty()) {
            ArrayList listFutures = new ArrayList();
            for (int i = 0; i < this.scenario.getExecutions().size(); ++i) {
                ScenarioExecution scenarioExecution = this.scenario.getExecutions().get(i);
                ScnExecutionCallable scnExecutionCallable = new ScnExecutionCallable("Agent-" + i, this, scenarioExecution, this.runParameters);
                listFutures.add(executor.submit(scnExecutionCallable));
            }
            try {
                for (Future future : listFutures) {
                    Object scnRunResult = future.get();
                    result.add((RunResult)scnRunResult);
                }
            }
            catch (ExecutionException ee) {
                result.addError(null, "Error during executing in parallel " + ee.getMessage());
            }
            catch (Exception e) {
                result.addError(null, "Error during executing in parallel " + e.getMessage());
            }
        }
        if (!this.scenario.getFlows().isEmpty()) {
            RunScenarioFlows scenarioFlows = new RunScenarioFlows(this.serviceAccess, this);
            scenarioFlows.execute(result);
        }
        return result;
    }

    public RunResult runVerifications(ScenarioExecution scnExecution) {
        RunResult result = new RunResult(this);
        RunScenarioVerification verifications = new RunScenarioVerification(scnExecution);
        result.add(verifications.runVerifications(this, result.getFirstProcessInstanceId()));
        return result;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public BpmnEngine getBpmnEngine() {
        return this.bpmnEngine;
    }

    public RunParameters getRunParameters() {
        return this.runParameters;
    }

    public ServiceAccess getServiceAccess() {
        return this.serviceAccess;
    }

    private static class ScnExecutionCallable
    implements Callable {
        private final String agentName;
        private final ScenarioExecution scnExecution;
        private final RunScenario runScenario;
        private final RunParameters runParameters;
        private RunResult scnRunResult;

        ScnExecutionCallable(String agentName, RunScenario runScenario, ScenarioExecution scnExecution, RunParameters runParameters) {
            this.agentName = agentName;
            this.runScenario = runScenario;
            this.scnExecution = scnExecution;
            this.runParameters = runParameters;
        }

        public Object call() {
            RunScenarioExecution scnRunExecution = new RunScenarioExecution(this.runScenario, this.scnExecution);
            scnRunExecution.setAgentName(this.agentName);
            this.scnRunResult = scnRunExecution.runExecution();
            return this.scnRunResult;
        }

        public RunResult getScnRunResult() {
            return this.scnRunResult;
        }
    }
}

