/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.RunScenarioVerification;
import org.camunda.automator.engine.RunZeebeOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioExecution {
    private final Logger logger = LoggerFactory.getLogger(RunScenarioExecution.class);
    private final RunScenario runScenario;
    private final ScenarioExecution scnExecution;
    private String agentName = "";

    public RunScenarioExecution(RunScenario runScenario, ScenarioExecution scnExecution) {
        this.runScenario = runScenario;
        this.scnExecution = scnExecution;
    }

    public void setAgentName(String name) {
        this.agentName = name;
    }

    public RunResult runExecution() {
        RunResult resultExecution = new RunResult(this.runScenario);
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": Start Execution [" + this.scnExecution.getName() + "] ");
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.scnExecution.getNumberOfThreads());
        ArrayList listFutures = new ArrayList();
        for (int i = 0; i < this.scnExecution.getNumberProcessInstances(); ++i) {
            ScnThreadExecutionCallable scnThreadExecutionCallable = new ScnThreadExecutionCallable("AutomatorThread-" + i, this, this.runScenario.getRunParameters());
            listFutures.add(executor.submit(scnThreadExecutionCallable));
        }
        try {
            for (Future future : listFutures) {
                Object scnRunResult = future.get();
                resultExecution.add((RunResult)scnRunResult);
            }
        }
        catch (Exception e) {
            resultExecution.addError(null, "Error during executing in parallel " + e.getMessage());
        }
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": End Execution [" + this.scnExecution.getName() + "] success? " + resultExecution.isSuccess());
        }
        return resultExecution;
    }

    public RunResult startEvent(RunResult result, ScenarioStep step) {
        try {
            result.addProcessInstanceId(step.getScnExecution().getScnHead().getProcessId(), this.runScenario.getBpmnEngine().createProcessInstance(step.getScnExecution().getScnHead().getProcessId(), step.getTaskId(), RunZeebeOperation.getVariablesStep(this.runScenario, step)));
        }
        catch (AutomatorException e) {
            result.addError(step, "Error at creation " + e.getMessage());
        }
        return result;
    }

    public RunResult executeUserTask(RunResult result, ScenarioStep step) {
        if (step.getDelay() != null) {
            Duration duration = Duration.parse(step.getDelay());
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Long waitingTimeInMs = null;
        if (step.getWaitingTime() != null) {
            Duration duration = Duration.parse(step.getWaitingTime());
            waitingTimeInMs = duration.toMillis();
        }
        if (waitingTimeInMs == null) {
            waitingTimeInMs = 300000L;
        }
        for (int index = 0; index < step.getNumberOfExecutions(); ++index) {
            long beginTimeWait = System.currentTimeMillis();
            try {
                List<String> listActivities;
                do {
                    if (!(listActivities = this.runScenario.getBpmnEngine().searchUserTasks(result.getFirstProcessInstanceId(), step.getTaskId(), 1)).isEmpty()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (listActivities.isEmpty() && System.currentTimeMillis() - beginTimeWait < waitingTimeInMs);
                if (listActivities.isEmpty()) {
                    result.addError(step, "No user task show up task[" + step.getTaskId() + "] processInstance[" + result.getFirstProcessInstanceId() + "]");
                    return result;
                }
                this.runScenario.getBpmnEngine().executeUserTask(listActivities.get(0), step.getUserId(), RunZeebeOperation.getVariablesStep(this.runScenario, step));
                continue;
            }
            catch (AutomatorException e) {
                result.addError(step, e.getMessage());
                return result;
            }
        }
        return result;
    }

    public RunResult executeServiceTask(RunResult result, ScenarioStep step) {
        if (step.getDelay() != null) {
            Duration duration = Duration.parse(step.getDelay());
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Long waitingTimeInMs = null;
        if (step.getWaitingTime() != null) {
            Duration duration = Duration.parse(step.getWaitingTime());
            waitingTimeInMs = duration.toMillis();
        }
        if (waitingTimeInMs == null) {
            waitingTimeInMs = 300000L;
        }
        for (int index = 0; index < step.getNumberOfExecutions(); ++index) {
            long beginTimeWait = System.currentTimeMillis();
            try {
                List<String> listActivities;
                do {
                    if (!(listActivities = this.runScenario.getBpmnEngine().searchServiceTasks(result.getFirstProcessInstanceId(), step.getTaskId(), step.getTopic(), 1)).isEmpty()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (listActivities.isEmpty() && System.currentTimeMillis() - beginTimeWait < waitingTimeInMs);
                if (listActivities.isEmpty()) {
                    result.addError(step, "No service task show up task[" + step.getTaskId() + "] processInstance[" + result.getFirstProcessInstanceId() + "]");
                    return result;
                }
                this.runScenario.getBpmnEngine().executeServiceTask(listActivities.get(0), step.getUserId(), RunZeebeOperation.getVariablesStep(this.runScenario, step));
                continue;
            }
            catch (AutomatorException e) {
                result.addError(step, e.getMessage());
                return result;
            }
        }
        return result;
    }

    private class ScnThreadExecutionCallable
    implements Callable {
        private final String agentName;
        private final RunScenarioExecution scnRunExecution;
        private final RunParameters runParameters;
        private RunResult scnRunResult;

        ScnThreadExecutionCallable(String agentName, RunScenarioExecution scnRunExecution, RunParameters runParameters) {
            this.agentName = agentName;
            this.scnRunExecution = scnRunExecution;
            this.runParameters = runParameters;
        }

        public Object call() throws Exception {
            this.scnRunResult = new RunResult(this.scnRunExecution.runScenario);
            if (this.runParameters.execution) {
                this.runExecution();
            }
            if (this.runParameters.verification && RunScenarioExecution.this.scnExecution.getVerifications() != null) {
                if (this.runParameters.execution) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.runVerifications();
                } else if (RunScenarioExecution.this.scnExecution.getVerifications().getSearchProcessInstanceByVariable().isEmpty()) {
                    this.scnRunResult.addVerification(null, false, "No Search Instance by Variable is defined");
                } else {
                    List<BpmnEngine.ProcessDescription> listProcessInstances = RunScenarioExecution.this.runScenario.getBpmnEngine().searchProcessInstanceByVariable(RunScenarioExecution.this.scnExecution.getScnHead().getProcessId(), RunScenarioExecution.this.scnExecution.getVerifications().getSearchProcessInstanceByVariable(), 100);
                    for (BpmnEngine.ProcessDescription processInstance : listProcessInstances) {
                        this.scnRunResult.addProcessInstanceId(RunScenarioExecution.this.scnExecution.getScnHead().getProcessId(), processInstance.processInstanceId);
                    }
                    this.runVerifications();
                }
            }
            if (this.scnRunResult.getFirstProcessInstanceId() != null && this.runParameters.clearAllAfter) {
                RunScenarioExecution.this.runScenario.getBpmnEngine().endProcessInstance(this.scnRunResult.getFirstProcessInstanceId(), this.runParameters.clearAllAfter);
            }
            return this.scnRunResult;
        }

        public void runExecution() {
            if (this.scnRunExecution.runScenario.getRunParameters().isLevelMonitoring()) {
                RunScenarioExecution.this.logger.info("ScnRunExecution.StartExecution [" + this.scnRunExecution.runScenario.getScenario().getName() + "] agent[" + this.agentName + "]");
            }
            for (ScenarioStep step : RunScenarioExecution.this.scnExecution.getSteps()) {
                if (this.scnRunExecution.runScenario.getRunParameters().isLevelDebug()) {
                    RunScenarioExecution.this.logger.info("ScnRunExecution.StartExecution.Execute [" + this.scnRunExecution.runScenario.getScenario().getName() + "." + step.getTaskId() + " agent[" + this.agentName + "]");
                }
                try {
                    step.checkConsistence();
                }
                catch (AutomatorException e) {
                    this.scnRunResult.addError(step, e.getMessage());
                    continue;
                }
                long timeBegin = System.currentTimeMillis();
                if (step.getType() == null) {
                    this.scnRunResult.addError(step, "Unknown type");
                    continue;
                }
                switch (step.getType()) {
                    case STARTEVENT: {
                        if (!this.scnRunExecution.runScenario.getRunParameters().creation) break;
                        this.scnRunResult = this.scnRunExecution.startEvent(this.scnRunResult, step);
                        break;
                    }
                    case USERTASK: {
                        if (!this.scnRunExecution.runScenario.getRunParameters().usertask) break;
                        this.scnRunResult = this.scnRunExecution.executeUserTask(this.scnRunResult, step);
                        break;
                    }
                    case SERVICETASK: {
                        if (!this.scnRunExecution.runScenario.getRunParameters().servicetask) break;
                        this.scnRunResult = this.scnRunExecution.executeServiceTask(this.scnRunResult, step);
                        break;
                    }
                    case ENDEVENT: {
                        break;
                    }
                }
                long timeEnd = System.currentTimeMillis();
                this.scnRunResult.addStepExecution(step, timeEnd - timeBegin);
                if (this.scnRunResult.isSuccess() || !ScenarioExecution.Policy.STOPATFIRSTERROR.equals((Object)RunScenarioExecution.this.scnExecution.getPolicy())) continue;
                return;
            }
            if (this.scnRunExecution.runScenario.getRunParameters().isLevelMonitoring()) {
                RunScenarioExecution.this.logger.info("ScnRunExecution.EndExecution [" + RunScenarioExecution.this.scnExecution.getName() + "] agent[" + this.agentName + "]");
            }
        }

        public void runVerifications() {
            RunScenarioVerification verifications = new RunScenarioVerification(RunScenarioExecution.this.scnExecution);
            for (String processInstanceId : this.scnRunResult.getProcessInstanceId()) {
                this.scnRunResult.add(verifications.runVerifications(this.scnRunExecution.runScenario, processInstanceId));
            }
        }

        public RunResult getScnRunResult() {
            return this.scnRunResult;
        }
    }
}

