/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import io.camunda.operate.search.DateFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.definition.ScenarioFlowControl;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunObjectives {
    private final BpmnEngine bpmnEngine;
    private final Map<String, RunResult.RecordCreationPI> recordCreationPIMap;
    private final Map<Integer, List<SavePhoto>> flowRateMnObjective = new HashMap<Integer, List<SavePhoto>>();
    private final List<ScenarioFlowControl.Objective> listObjectives;
    Logger logger = LoggerFactory.getLogger(RunObjectives.class);
    private DateFilter startDateFilter;
    private DateFilter endDateFilter;
    private long lastHeartBeat;

    public RunObjectives(List<ScenarioFlowControl.Objective> listObjectives, BpmnEngine bpmnEngine, Map<String, RunResult.RecordCreationPI> recordCreationPIMap) {
        this.listObjectives = listObjectives;
        this.bpmnEngine = bpmnEngine;
        this.recordCreationPIMap = recordCreationPIMap;
        for (int i = 0; i < listObjectives.size(); ++i) {
            listObjectives.get((int)i).index = i;
        }
    }

    public void setStartDate(Date startTestDate) {
        this.startDateFilter = new DateFilter(startTestDate);
        this.lastHeartBeat = System.currentTimeMillis();
    }

    public void setEndDate(Date endTestDate) {
        this.endDateFilter = new DateFilter(endTestDate);
    }

    public void heartBeat() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastHeartBeat < 60000L) {
            return;
        }
        for (ScenarioFlowControl.Objective objective : this.listObjectives) {
            if (!ScenarioFlowControl.Objective.TYPEOBJECTIVE.FLOWRATEUSERTASKMN.equals((Object)objective.type)) continue;
            SavePhoto currentPhoto = new SavePhoto();
            try {
                currentPhoto.nbOfTasks = this.bpmnEngine.countNumberOfTasks(objective.processId, objective.taskId);
            }
            catch (AutomatorException e) {
                this.logger.error("Can't get NumberOfTask ");
            }
            List listValues = this.flowRateMnObjective.getOrDefault(objective.index, new ArrayList());
            SavePhoto previousPhoto = listValues.isEmpty() ? new SavePhoto() : (SavePhoto)listValues.get(listValues.size() - 1);
            currentPhoto.delta = currentPhoto.nbOfTasks - previousPhoto.nbOfTasks;
            listValues.add(currentPhoto);
            this.flowRateMnObjective.put(objective.index, listValues);
            this.logger.info("heartBeat: FlowRateUserTaskMn [{}] prev [{}} current [{}] delta [{}] expected [{}] in {} s", new Object[]{objective.label, previousPhoto.nbOfTasks, currentPhoto.nbOfTasks, currentPhoto.delta, objective.value, (currentTime - this.lastHeartBeat) / 1000L});
        }
        this.lastHeartBeat = currentTime;
    }

    public List<ObjectiveResult> check() {
        ArrayList<ObjectiveResult> listCheck = new ArrayList<ObjectiveResult>();
        for (ScenarioFlowControl.Objective objective : this.listObjectives) {
            listCheck.add(switch (objective.type) {
                default -> throw new IncompatibleClassChangeError();
                case ScenarioFlowControl.Objective.TYPEOBJECTIVE.CREATED -> this.checkObjectiveCreated(objective);
                case ScenarioFlowControl.Objective.TYPEOBJECTIVE.ENDED -> this.checkObjectiveEnded(objective);
                case ScenarioFlowControl.Objective.TYPEOBJECTIVE.USERTASK -> this.checkObjectiveUserTask(objective);
                case ScenarioFlowControl.Objective.TYPEOBJECTIVE.FLOWRATEUSERTASKMN -> this.checkObjectiveFlowRate(objective);
            });
        }
        return listCheck;
    }

    private ObjectiveResult checkObjectiveCreated(ScenarioFlowControl.Objective objective) {
        ObjectiveResult objectiveResult = new ObjectiveResult(objective);
        objectiveResult.objectiveValue = objective.value.intValue();
        if (objective.value <= 0) {
            objectiveResult.success = true;
            objectiveResult.analysis = objectiveResult.analysis + "No value to reach";
            return objectiveResult;
        }
        try {
            long processInstancesCreatedAPI = this.bpmnEngine.countNumberOfProcessInstancesCreated(objective.processId, this.startDateFilter, this.endDateFilter);
            RunResult.RecordCreationPI recordCreation = this.recordCreationPIMap.getOrDefault(objective.processId, new RunResult.RecordCreationPI(objective.processId));
            objectiveResult.recordedSuccessValue = recordCreation.nbCreated;
            objectiveResult.recordedFailValue = recordCreation.nbFailed;
            int percent = (int)(100.0 * (double)objectiveResult.recordedSuccessValue / (double)(objective.value == 0 ? 1 : objective.value));
            objectiveResult.analysis = objectiveResult.analysis + "Objective " + objective.label + ": ObjectiveCreation[" + objective.value + "] Created(zeebeAPI)[" + processInstancesCreatedAPI + "] Create(AutomatorRecord)[" + objectiveResult.recordedSuccessValue + " (" + percent + " % ) CreateFail(AutomatorRecord)[" + objectiveResult.recordedFailValue + "]";
            if (objectiveResult.recordedSuccessValue < (long)objective.value.intValue()) {
                objectiveResult.success = false;
            }
        }
        catch (AutomatorException e) {
            objectiveResult.success = false;
            objectiveResult.analysis = objectiveResult.analysis + "Can't search countNumberOfProcessInstancesCreated " + e.getMessage();
        }
        return objectiveResult;
    }

    private ObjectiveResult checkObjectiveEnded(ScenarioFlowControl.Objective objective) {
        ObjectiveResult objectiveResult = new ObjectiveResult(objective);
        objectiveResult.objectiveValue = objective.value.intValue();
        if (objective.value <= 0) {
            objectiveResult.success = true;
            objectiveResult.analysis = objectiveResult.analysis + "No value to reach";
            return objectiveResult;
        }
        try {
            objectiveResult.recordedSuccessValue = this.bpmnEngine.countNumberOfProcessInstancesEnded(objective.processId, this.startDateFilter, this.endDateFilter);
            if (objectiveResult.recordedSuccessValue < (long)objective.value.intValue()) {
                objectiveResult.analysis = objectiveResult.analysis + "Fail: " + objective.label + " : " + objective.value + " ended expected, " + objectiveResult.recordedSuccessValue + " created (" + (int)(100.0 * (double)objectiveResult.recordedSuccessValue / (double)objective.value.intValue()) + " %), ";
                objectiveResult.success = false;
            }
        }
        catch (AutomatorException e) {
            objectiveResult.success = false;
            objectiveResult.analysis = objectiveResult.analysis + "Can't search NumberOfProcessInstanceEnded: " + e.getMessage();
        }
        return objectiveResult;
    }

    private ObjectiveResult checkObjectiveUserTask(ScenarioFlowControl.Objective objective) {
        ObjectiveResult objectiveResult = new ObjectiveResult(objective);
        objectiveResult.objectiveValue = objective.value.intValue();
        if (objective.value <= 0) {
            objectiveResult.success = true;
            objectiveResult.analysis = objectiveResult.analysis + "No value to reach";
            return objectiveResult;
        }
        try {
            objectiveResult.recordedSuccessValue = this.bpmnEngine.countNumberOfTasks(objective.processId, objective.taskId);
            if (objectiveResult.recordedSuccessValue < (long)objective.value.intValue()) {
                objectiveResult.analysis = objectiveResult.analysis + "Fail: " + objective.label + " : [" + objective.value + "] tasks expected, ";
                objectiveResult.analysis = objectiveResult.analysis + objectiveResult.recordedSuccessValue + " found (" + (int)(100.0 * (double)objectiveResult.recordedSuccessValue / (double)objective.value.intValue()) + " %), ";
                objectiveResult.success = false;
            }
        }
        catch (AutomatorException e) {
            objectiveResult.success = false;
            objectiveResult.analysis = objectiveResult.analysis + "Can't search NumberOfProcessInstanceEnded: " + e.getMessage();
        }
        return objectiveResult;
    }

    private ObjectiveResult checkObjectiveFlowRate(ScenarioFlowControl.Objective objective) {
        ObjectiveResult objectiveResult = new ObjectiveResult(objective);
        try {
            long averageValue;
            long lowThreshold = (long)((double)objective.value.intValue() * (1.0 - (double)objective.getStandardDeviation() / 100.0));
            objectiveResult.objectiveValue = objective.value.intValue();
            objectiveResult.analysis = objectiveResult.analysis + "Threshold[" + objective.value + "] standardDeviation[" + objective.getStandardDeviation() + "] LowThreshold[" + lowThreshold + "]";
            long sumValues = 0L;
            List listValues = this.flowRateMnObjective.getOrDefault(objective.index, new ArrayList());
            if (listValues.isEmpty()) {
                objectiveResult.analysis = objectiveResult.analysis + "No values";
                objectiveResult.success = false;
                return objectiveResult;
            }
            StringBuilder valuesString = new StringBuilder();
            int numberUnderThreshold = 0;
            int count = 0;
            for (SavePhoto photo : listValues) {
                sumValues += photo.delta;
                if (++count == 50) {
                    valuesString.append("... TooManyValues[");
                    valuesString.append(listValues.size());
                    valuesString.append("]");
                }
                if (count < 50) {
                    valuesString.append(photo.delta);
                    valuesString.append(",");
                }
                if (photo.delta >= lowThreshold) continue;
                ++numberUnderThreshold;
            }
            if (numberUnderThreshold > 0) {
                objectiveResult.analysis = objectiveResult.analysis + "NumberOrValueUnderThreshold[" + numberUnderThreshold + "], values: " + valuesString;
                objectiveResult.success = false;
            }
            objectiveResult.recordedSuccessValue = averageValue = (long)((double)sumValues / (double)listValues.size());
            if (averageValue < (long)objective.value.intValue()) {
                objectiveResult.analysis = objectiveResult.analysis + "AverageUnderObjective[" + averageValue + "]";
                objectiveResult.success = false;
            } else {
                objectiveResult.analysis = objectiveResult.analysis + "AverageReach[" + averageValue + "]";
            }
        }
        catch (Exception e) {
            this.logger.error("Error during checkFlowRateObjective {}", (Object)e.getMessage());
            objectiveResult.success = false;
        }
        return objectiveResult;
    }

    public static class SavePhoto {
        public long nbOfTasks = 0L;
        public long delta = 0L;
    }

    public static class ObjectiveResult {
        public String analysis = "";
        public boolean success = true;
        public long objectiveValue;
        public long recordedSuccessValue;
        public long recordedFailValue;
        ScenarioFlowControl.Objective objective;

        public ObjectiveResult(ScenarioFlowControl.Objective objective) {
            this.objective = objective;
        }
    }
}

