/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services;

import java.io.File;
import java.time.Instant;
import java.util.List;
import javax.annotation.PostConstruct;
import org.camunda.automator.AutomatorAPI;
import org.camunda.automator.AutomatorCLI;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.configuration.ConfigurationStartup;
import org.camunda.automator.definition.Scenario;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomatorStartup {
    static Logger logger = LoggerFactory.getLogger(AutomatorStartup.class);
    @Autowired
    ConfigurationStartup configurationStartup;
    @Autowired
    AutomatorAPI automatorAPI;
    @Autowired
    AutomatorCLI automatorCLI;
    @Autowired
    ConfigurationBpmEngine engineConfiguration;
    @Autowired
    ServiceAccess serviceAccess;

    @PostConstruct
    public void init() {
        if (AutomatorCLI.isRunningCLI) {
            return;
        }
        AutomatorSetupRunnable automatorSetupRunnable = new AutomatorSetupRunnable(this.configurationStartup, this.automatorAPI, this.automatorCLI, this.engineConfiguration);
        this.serviceAccess.getTaskScheduler("AutomatorSetup").schedule((Runnable)automatorSetupRunnable, Instant.now());
    }

    class AutomatorSetupRunnable
    implements Runnable {
        ConfigurationStartup configurationStartup;
        AutomatorAPI automatorAPI;
        AutomatorCLI automatorCLI;
        ConfigurationBpmEngine engineConfiguration;

        public AutomatorSetupRunnable(ConfigurationStartup configurationStartup, AutomatorAPI automatorAPI, AutomatorCLI automatorCLI, ConfigurationBpmEngine engineConfiguration) {
            this.configurationStartup = configurationStartup;
            this.automatorAPI = automatorAPI;
            this.automatorCLI = automatorCLI;
            this.engineConfiguration = engineConfiguration;
        }

        @Override
        public void run() {
            RunParameters runParameters = new RunParameters();
            runParameters.execution = true;
            runParameters.logLevel = this.configurationStartup.getLogLevelEnum();
            runParameters.creation = this.configurationStartup.isPolicyExecutionCreation();
            runParameters.servicetask = this.configurationStartup.isPolicyExecutionServiceTask();
            runParameters.usertask = this.configurationStartup.isPolicyExecutionUserTask();
            runParameters.warmingUp = this.configurationStartup.isPolicyExecutionWarmingUp();
            runParameters.deploymentProcess = this.configurationStartup.isPolicyDeployProcess();
            runParameters.deepTracking = this.configurationStartup.deepTracking();
            List<String> filterService = this.configurationStartup.getFilterService();
            if (filterService != null) {
                runParameters.setFilterExecutionServiceTask(filterService);
            }
            logger.info("AutomatorStartup parameters warmingUp[{}] creation:[{}] serviceTask:[{}] userTask:[{}] ScenarioPath[{}] logLevel[{}] waitWarmingUpServer[{} s]", new Object[]{runParameters.warmingUp, runParameters.creation, runParameters.servicetask, runParameters.usertask, this.configurationStartup.scenarioPath, this.configurationStartup.logLevel, this.configurationStartup.getWarmingUpServer().toMillis() / 1000L});
            try {
                String currentPath = new File(".").getCanonicalPath();
                logger.info("Local Path[{}]", (Object)currentPath);
            }
            catch (Exception e) {
                logger.error("Can't access Local Path : {} ", (Object)e.getMessage());
            }
            if (this.configurationStartup.getWarmingUpServer().getSeconds() > 30L) {
                logger.info("Warmup: wait.... {} s", (Object)this.configurationStartup.getWarmingUpServer().getSeconds());
            }
            try {
                Thread.sleep(this.configurationStartup.getWarmingUpServer().toMillis());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.configurationStartup.getWarmingUpServer().getSeconds() > 30L) {
                logger.info("Warmup: start now");
            }
            for (String scenarioFileName : this.configurationStartup.scenarioAtStartup) {
                File scenarioFile = new File(this.configurationStartup.scenarioPath + "/" + scenarioFileName);
                if (!scenarioFile.exists()) {
                    logger.error("Can't find [{}/{}]", (Object)this.configurationStartup.scenarioPath, (Object)scenarioFileName);
                    continue;
                }
                try {
                    Scenario scenario = this.automatorAPI.loadFromFile(scenarioFile);
                    logger.info("Start scenario [{}]", (Object)scenario.getName());
                    int countEngineIsNotReady = 0;
                    BpmnEngine bpmnEngine = null;
                    boolean pleaseTryAgain = false;
                    do {
                        ++countEngineIsNotReady;
                        try {
                            if (runParameters.isLevelMonitoring()) {
                                logger.info("Connect to Bpmn Engine Type{}", (Object)scenario.getServerType());
                            }
                            if (!(bpmnEngine = this.automatorAPI.getBpmnEngineFromScenario(scenario, this.engineConfiguration)).isReady()) {
                                bpmnEngine.connection();
                            }
                        }
                        catch (AutomatorException e) {
                            pleaseTryAgain = true;
                        }
                        if (!pleaseTryAgain || countEngineIsNotReady >= 10) continue;
                        logger.info("Scenario [{}] file[{}] No BPM ENGINE running Sleep 30s. Scenario reference serverName[{}] serverType[{}]", new Object[]{scenario.getName(), scenarioFile.getName(), scenario.getServerName(), scenario.getServerType()});
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (pleaseTryAgain && countEngineIsNotReady < 10);
                    if (bpmnEngine == null) {
                        logger.error("Scenario [{}] file[{}] No BPM ENGINE running. Scenario reference serverName[{}] serverType[{}]", new Object[]{scenario.getName(), scenarioFile.getName(), scenario.getServerName(), scenario.getServerType()});
                        continue;
                    }
                    bpmnEngine.turnHighFlowMode(true);
                    logger.info("Scenario [{}] file[{}] use BpmnEngine {}", new Object[]{scenario.getName(), scenarioFile.getName(), bpmnEngine.getSignature()});
                    RunResult scenarioExecutionResult = this.automatorAPI.executeScenario(bpmnEngine, runParameters, scenario);
                    logger.info("AutomatorStartup: end scenario [{}] in {} ms", (Object)scenario.getName(), (Object)scenarioExecutionResult.getTimeExecution());
                    bpmnEngine.turnHighFlowMode(false);
                }
                catch (AutomatorException e) {
                    logger.error("Error during execution [{}]: {}", (Object)scenarioFileName, (Object)e.getMessage());
                }
            }
        }
    }
}

