/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.camunda.community.bpmndt.Generator;
import org.camunda.community.bpmndt.GeneratorContext;

@Mojo(name="generator", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="generated", required=true)
    protected String packageName;

    public void execute() throws MojoFailureException {
        Path testSourcePath = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("bpmndt");
        this.getLog().info((CharSequence)String.format("Adding test source directory: %s", testSourcePath));
        this.project.addTestCompileSourceRoot(testSourcePath.toAbsolutePath().toString());
        this.getLog().info((CharSequence)"");
        GeneratorContext ctx = new GeneratorContext();
        ctx.setBasePath(this.project.getBasedir().toPath());
        ctx.setMainResourcePath(Paths.get(((Resource)this.project.getBuild().getResources().get(0)).getDirectory(), new String[0]));
        ctx.setPackageName(this.packageName);
        ctx.setTestSourcePath(testSourcePath);
        try {
            new Generator().generate(ctx);
        }
        catch (RuntimeException e) {
            throw new MojoFailureException("Unexpected error occurred", (Throwable)e);
        }
    }
}

