/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.camunda.community.bpmndt.GeneratorTask;
import org.camunda.community.bpmndt.GradleExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradlePlugin
implements Plugin<Project> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradlePlugin.class);
    private static final String SOURCE_SET_NAME = "bpmndtTestCases";

    public void apply(Project project) {
        GradleExtension extension = (GradleExtension)project.getExtensions().create("bpmndt", GradleExtension.class, new Object[0]);
        Path testSourcePath = project.getBuildDir().toPath().resolve("bpmndt");
        try {
            Files.createDirectories(testSourcePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Test source directory '%s' could not be created", testSourcePath), e);
        }
        LOGGER.info(String.format("Adding test source directory: %s", testSourcePath));
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet testSourceSet = (SourceSet)javaExtension.getSourceSets().getByName("test");
        SourceSet additionalTestSourceSet = (SourceSet)javaExtension.getSourceSets().create(SOURCE_SET_NAME);
        additionalTestSourceSet.getJava().setSrcDirs(Collections.singleton(testSourcePath.toFile()));
        additionalTestSourceSet.setAnnotationProcessorPath(testSourceSet.getAnnotationProcessorPath());
        additionalTestSourceSet.setCompileClasspath(testSourceSet.getCompileClasspath());
        additionalTestSourceSet.setRuntimeClasspath(testSourceSet.getRuntimeClasspath());
        testSourceSet.getJava().source(additionalTestSourceSet.getJava());
        GeneratorTask generatorTask = (GeneratorTask)((Object)project.getTasks().register("generateTestCases", GeneratorTask.class, task -> {
            SourceSet mainSourceSet = (SourceSet)javaExtension.getSourceSets().getByName("main");
            task.setExtension(extension);
            task.setMainResourcePath(Paths.get(mainSourceSet.getResources().getSourceDirectories().getAsPath(), new String[0]));
            task.setTestSourcePath(testSourcePath);
        }).get());
        project.afterEvaluate(afterEvaluate -> afterEvaluate.getTasksByName("compileTestJava", false).forEach(task -> task.dependsOn(new Object[]{generatorTask})));
    }
}

