/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.camunda.community.bpmndt.Generator;
import org.camunda.community.bpmndt.GeneratorContext;
import org.camunda.community.bpmndt.GradleExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorTask
extends DefaultTask {
    protected static final String NAME = "generateTestCases";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorTask.class);
    @Internal
    private GradleExtension extension;
    @Internal
    private Path mainResourcePath;
    @Internal
    private Path testSourcePath;

    @TaskAction
    public void generate() {
        String packageName = (String)this.extension.getPackageName().getOrElse((Object)"generated");
        List processEnginePlugins = (List)this.extension.getProcessEnginePlugins().getOrElse(Collections.emptyList());
        boolean springEnabled = (Boolean)this.extension.getSpringEnabled().getOrElse((Object)Boolean.FALSE);
        boolean externalTaskClientUsed = this.hasExternalTaskClientDependency(this.getProject());
        if (externalTaskClientUsed) {
            LOGGER.info("Found external task client");
            LOGGER.info("");
        }
        GeneratorContext ctx = new GeneratorContext();
        ctx.setBasePath(this.getProject().getProjectDir().toPath());
        ctx.setExternalTaskClientUsed(externalTaskClientUsed);
        ctx.setMainResourcePath(this.mainResourcePath);
        ctx.setPackageName(packageName);
        ctx.setProcessEnginePluginNames(processEnginePlugins);
        ctx.setSpringEnabled(springEnabled);
        ctx.setTestSourcePath(this.testSourcePath);
        new Generator().generate(ctx);
    }

    public GradleExtension getExtension() {
        return this.extension;
    }

    public Path getMainResourcePath() {
        return this.mainResourcePath;
    }

    public Path getTestSourcePath() {
        return this.testSourcePath;
    }

    public void setExtension(GradleExtension extension) {
        this.extension = extension;
    }

    public void setMainResourcePath(Path mainResourcePath) {
        this.mainResourcePath = mainResourcePath;
    }

    public void setTestSourcePath(Path testSourcePath) {
        this.testSourcePath = testSourcePath;
    }

    private boolean hasExternalTaskClientDependency(Project project) {
        return this.hasExternalTaskClientDependency(project, "compileClasspath") || this.hasExternalTaskClientDependency(project, "runtimeClasspath");
    }

    private boolean hasExternalTaskClientDependency(Project project, String configurationName) {
        Configuration compileConfiguration;
        try {
            compileConfiguration = project.getConfigurations().getByName(configurationName);
        }
        catch (UnknownConfigurationException e) {
            return false;
        }
        ResolvableDependencies incoming = compileConfiguration.getIncoming();
        if (incoming == null) {
            return false;
        }
        ResolutionResult resolutionResult = incoming.getResolutionResult();
        if (resolutionResult == null) {
            return false;
        }
        Set allDependencies = resolutionResult.getAllDependencies();
        if (allDependencies == null) {
            return false;
        }
        return allDependencies.stream().anyMatch(dependencyResult -> dependencyResult.toString().startsWith("org.camunda.bpm:camunda-external-task-client:"));
    }
}

