/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.camunda.bpm.extension.bpmndt.GeneratorTask;

@Mojo(name="generator", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresProject=true)
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="generated", required=true)
    protected String packageName;
    @Parameter(defaultValue="false", required=true)
    protected boolean springEnabled;
    @Parameter(defaultValue="bpmndt", required=true)
    protected String testSourceDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path testSourcePath = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.testSourceDirectory);
        this.getLog().info((CharSequence)String.format("Adding test source directory: %s", testSourcePath));
        this.project.addTestCompileSourceRoot(testSourcePath.toAbsolutePath().toString());
        this.getLog().info((CharSequence)"");
        GeneratorTask task = new GeneratorTask(this.getLog());
        task.basePath = this.project.getBasedir().toPath();
        task.mainResourcePath = Paths.get(((Resource)this.project.getBuild().getResources().get(0)).getDirectory(), new String[0]);
        task.testSourcePath = testSourcePath;
        task.packageName = this.packageName;
        task.springEnabled = this.springEnabled;
        try {
            task.execute();
        }
        catch (RuntimeException e) {
            throw new MojoFailureException("Unexpected error occurred", (Throwable)e);
        }
    }
}

