/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt;

import com.squareup.javapoet.JavaFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.camunda.bpm.extension.bpmndt.BpmnSupport;
import org.camunda.bpm.extension.bpmndt.Generator;
import org.camunda.bpm.extension.bpmndt.type.TestCase;

public class GeneratorTask {
    private final Log log;
    protected Path basePath;
    protected Path mainResourcePath;
    protected Path testSourcePath;
    protected String packageName;
    protected boolean springEnabled;

    public GeneratorTask(Log log) {
        this.log = log;
    }

    protected Path buildJavaFilePath(JavaFile javaFile) {
        String javaFileName = javaFile.typeSpec.name + ".java";
        return this.testSourcePath.resolve(javaFile.packageName.replace('.', '/')).resolve(javaFileName);
    }

    protected void deleteJavaFiles() {
        if (!Files.isDirectory(this.testSourcePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(this.testSourcePath).map(Path::toFile).forEach(FileUtils::deleteQuietly);
        }
        catch (IOException e) {
            throw new RuntimeException("Generated Java files in '%s' could not be deleted", e);
        }
    }

    public void execute() {
        this.deleteJavaFiles();
        Collection<Path> bpmnFiles = BpmnSupport.collectFiles(this.mainResourcePath);
        for (Path bpmnFile : bpmnFiles) {
            this.log.info((CharSequence)String.format("Found BPMN file: %s", this.relativize(this.mainResourcePath, bpmnFile)));
        }
        LinkedList<JavaFile> javaFiles = new LinkedList<JavaFile>();
        for (Path bpmnFile : bpmnFiles) {
            this.log.info((CharSequence)"");
            this.generate(javaFiles, bpmnFile);
        }
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"Writing test cases");
        javaFiles.forEach(this::writeJavaFile);
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"Writing framework classes");
        this.generateFramework().forEach(this::writeJavaFile);
    }

    protected void generate(List<JavaFile> javaFiles, Path bpmnFile) {
        BpmnSupport bpmnSupport = BpmnSupport.of(bpmnFile);
        this.log.info((CharSequence)String.format("Process: %s", bpmnSupport.getProcessId()));
        Generator generator = Generator.builder().bpmnResourceName(this.relativize(this.mainResourcePath, bpmnFile)).bpmnSupport(bpmnSupport).packageName(this.packageName).springEnabled(this.springEnabled).build();
        List<TestCase> testCases = bpmnSupport.getTestCases();
        if (testCases.isEmpty()) {
            this.log.info((CharSequence)"No test cases defined");
            return;
        }
        HashSet<String> testCaseNames = new HashSet<String>();
        for (TestCase testCase : testCases) {
            String testCaseName = testCase.getName();
            if (testCaseNames.contains(testCaseName)) {
                this.log.warn((CharSequence)String.format("Skipping test case '%s': Name must be unique", testCaseName));
                continue;
            }
            this.log.info((CharSequence)String.format("Generating test case '%s'", testCaseName));
            javaFiles.add(generator.generate(testCase));
            testCaseNames.add(testCaseName);
        }
        testCaseNames.clear();
    }

    protected List<JavaFile> generateFramework() {
        Generator generator = Generator.builder().packageName(this.packageName).springEnabled(this.springEnabled).build();
        return generator.generateFramework();
    }

    private String relativize(Path parent, Path child) {
        return parent.relativize(child).toString().replace('\\', '/');
    }

    protected void writeJavaFile(JavaFile javaFile) {
        Path javaFilePath = this.buildJavaFilePath(javaFile);
        this.log.info((CharSequence)String.format("Writing file: %s", this.relativize(this.basePath, javaFilePath)));
        try {
            Files.createDirectories(javaFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Parent directories could not be created", e);
        }
        try (BufferedWriter w = Files.newBufferedWriter(javaFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            javaFile.writeTo((Appendable)w);
        }
        catch (IOException e) {
            throw new RuntimeException("Test case could not be written", e);
        }
    }
}

