/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SubProcess;

class BpmnNodeCollector {
    private final List<FlowNode> flowNodes = new LinkedList<FlowNode>();

    BpmnNodeCollector() {
    }

    protected Collection<FlowNode> collect(Process process) {
        this.flowNodes.clear();
        this.collect(process.getFlowElements());
        this.collectSubProcesses(process.getChildElementsByType(SubProcess.class));
        return this.flowNodes;
    }

    protected void collect(Collection<FlowElement> elements) {
        elements.stream().filter(this::isFlowNode).map(FlowNode.class::cast).forEach(this.flowNodes::add);
    }

    protected void collectSubProcesses(Collection<SubProcess> subProcesses) {
        for (SubProcess subProcess : subProcesses) {
            this.collect(subProcess.getFlowElements());
            this.collectSubProcesses(subProcess.getChildElementsByType(SubProcess.class));
        }
    }

    private boolean isFlowNode(FlowElement element) {
        return FlowNode.class.isAssignableFrom(element.getClass());
    }
}

