/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl;

import java.util.Optional;
import org.camunda.bpm.extension.bpmndt.BpmnNode;
import org.camunda.bpm.extension.bpmndt.BpmnSupport;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.TimerEventDefinition;

class BpmnNodeImpl
implements BpmnNode {
    private final FlowNode flowNode;

    BpmnNodeImpl(FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    @Override
    public <T extends FlowNode> T as(Class<T> type) {
        return (T)((FlowNode)type.cast(this.flowNode));
    }

    @Override
    public String getId() {
        return this.flowNode.getId();
    }

    @Override
    public String getLiteral() {
        return BpmnSupport.convert(this.flowNode.getId());
    }

    @Override
    public String getType() {
        return this.flowNode.getElementType().getTypeName();
    }

    protected boolean is(String typeName) {
        return this.flowNode.getElementType().getTypeName().equals(typeName);
    }

    @Override
    public boolean isAsyncAfter() {
        return this.flowNode.isCamundaAsyncAfter();
    }

    @Override
    public boolean isAsyncBefore() {
        return this.flowNode.isCamundaAsyncBefore();
    }

    @Override
    public boolean isCallActivity() {
        return this.is("callActivity");
    }

    @Override
    public boolean isExternalTask() {
        if (this.is("serviceTask")) {
            ServiceTask serviceTask = (ServiceTask)this.flowNode;
            return "external".equals(serviceTask.getCamundaType());
        }
        return false;
    }

    @Override
    public boolean isIntermediateCatchEvent() {
        return this.is("intermediateCatchEvent");
    }

    @Override
    public boolean isJob() {
        if (this.flowNode.isCamundaAsyncBefore() || this.flowNode.isCamundaAsyncAfter()) {
            return true;
        }
        if (!this.isIntermediateCatchEvent()) {
            return false;
        }
        IntermediateCatchEvent event = (IntermediateCatchEvent)this.flowNode;
        Optional eventDefinition = event.getEventDefinitions().stream().findFirst();
        return eventDefinition.isPresent() && eventDefinition.get() instanceof TimerEventDefinition;
    }

    @Override
    public boolean isUserTask() {
        return this.is("userTask");
    }
}

