/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.camunda.bpm.engine.test.assertions.ProcessEngineTests;
import org.camunda.bpm.extension.bpmndt.BpmnNode;
import org.camunda.bpm.extension.bpmndt.BpmnSupport;
import org.camunda.bpm.extension.bpmndt.Generator;
import org.camunda.bpm.extension.bpmndt.GeneratorContext;
import org.camunda.bpm.extension.bpmndt.impl.generation.AbstractTestCase;
import org.camunda.bpm.extension.bpmndt.impl.generation.After;
import org.camunda.bpm.extension.bpmndt.impl.generation.Before;
import org.camunda.bpm.extension.bpmndt.impl.generation.BpmndtConfiguration;
import org.camunda.bpm.extension.bpmndt.impl.generation.BpmndtPlugin;
import org.camunda.bpm.extension.bpmndt.impl.generation.CallActivityParseListener;
import org.camunda.bpm.extension.bpmndt.impl.generation.CallActivityRule;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleAsyncAfter;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleAsyncBefore;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleCallActivityInput;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleCallActivityOutput;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleExternalTask;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleIntermediateCatchEvent;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleUserTask;
import org.camunda.bpm.extension.bpmndt.impl.generation.TestMethod;
import org.camunda.bpm.extension.bpmndt.impl.generation.TestMethodPathEmpty;
import org.camunda.bpm.extension.bpmndt.impl.generation.TestMethodPathNotValid;
import org.camunda.bpm.extension.bpmndt.type.Path;
import org.camunda.bpm.extension.bpmndt.type.TestCase;

class GeneratorImpl
implements Generator {
    private final GeneratorContext context;

    GeneratorImpl(GeneratorContext context) {
        this.context = context;
    }

    protected CodeBlock buildJavadoc(GeneratorContext context, TestCase testCase) {
        Path path = testCase.getPath();
        BpmnNode startNode = context.getBpmnSupport().get(path.getStart());
        BpmnNode endNode = context.getBpmnSupport().get(path.getEnd());
        CodeBlock.Builder builder = CodeBlock.builder();
        if (testCase.getDescription() != null) {
            builder.add(testCase.getDescription(), new Object[0]);
            builder.add("\n<br>\n", new Object[0]);
        }
        builder.add("Start:", new Object[0]);
        builder.add("\n<br>\n", new Object[0]);
        builder.add("$L: $L", new Object[]{startNode.getType(), startNode.getId()});
        builder.add("\n<br><br>\n", new Object[0]);
        builder.add("End:", new Object[0]);
        builder.add("\n<br>\n", new Object[0]);
        builder.add("$L: $L", new Object[]{endNode.getType(), endNode.getId()});
        builder.add("\n<br><br>\n", new Object[0]);
        builder.add("Flow nodes:", new Object[0]);
        builder.add("\n<br>\n", new Object[0]);
        builder.add("$L", new Object[]{path.getFlowNodeIds().size()});
        return builder.build();
    }

    protected void buildStaticImports(TestCase testCase, JavaFile.Builder javaFileBuilder) {
        List<String> flowNodeIds = testCase.getPath().getFlowNodeIds();
        HashSet<String> bpmnAwareHelpers = new HashSet<String>();
        bpmnAwareHelpers.add("assertThat");
        if (this.context.getBpmnSupport().hasJob(flowNodeIds)) {
            bpmnAwareHelpers.add("job");
        }
        if (this.context.getBpmnSupport().hasUserTask(flowNodeIds)) {
            bpmnAwareHelpers.add("task");
        }
        if (!bpmnAwareHelpers.isEmpty()) {
            javaFileBuilder.addStaticImport(ProcessEngineTests.class, bpmnAwareHelpers.toArray(new String[0]));
        }
    }

    protected boolean buildTestCase(TestCase testCase, TypeSpec.Builder classBuilder) {
        List<String> flowNodeIds = testCase.getPath().getFlowNodeIds();
        if (flowNodeIds.isEmpty()) {
            classBuilder.addMethod(new TestMethodPathEmpty().apply(this.context, testCase));
            return false;
        }
        BpmnSupport bpmnSupport = this.context.getBpmnSupport();
        if (!bpmnSupport.has(flowNodeIds)) {
            classBuilder.addMethod(new TestMethodPathNotValid().apply(this.context, testCase));
            return false;
        }
        classBuilder.addMethod(new TestMethod().apply(this.context, testCase));
        for (String flowNodeId : flowNodeIds) {
            BpmnNode node = bpmnSupport.get(flowNodeId);
            if (node.isAsyncBefore()) {
                classBuilder.addMethod(new HandleAsyncBefore().apply(node));
            }
            if (node.isCallActivity()) {
                classBuilder.addMethod(new HandleCallActivityInput().apply(node));
                classBuilder.addMethod(new HandleCallActivityOutput().apply(node));
            }
            if (node.isExternalTask()) {
                classBuilder.addMethod(new HandleExternalTask().apply(node));
            }
            if (node.isIntermediateCatchEvent()) {
                classBuilder.addMethod(new HandleIntermediateCatchEvent().apply(node));
            }
            if (node.isUserTask()) {
                classBuilder.addMethod(new HandleUserTask().apply(node));
            }
            if (!node.isAsyncAfter()) continue;
            classBuilder.addMethod(new HandleAsyncAfter().apply(node));
        }
        classBuilder.addMethod(new After().apply(this.context));
        return true;
    }

    protected String buildTestCaseClassName(TestCase testCase) {
        String processId = BpmnSupport.convert(this.context.getBpmnSupport().getProcessId());
        return String.format("TC_%s__%s", processId, testCase.getName());
    }

    protected JavaFile buildType(Function<GeneratorContext, TypeSpec> builderFunction) {
        return JavaFile.builder((String)this.context.getPackageName(), (TypeSpec)builderFunction.apply(this.context)).skipJavaLangImports(true).build();
    }

    @Override
    public JavaFile generate(TestCase testCase) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.buildTestCaseClassName(testCase)).addJavadoc(this.buildJavadoc(this.context, testCase)).superclass((TypeName)ClassName.get((String)this.context.getPackageName(), (String)"AbstractTestCase", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addMethod(new Before().apply(this.context));
        boolean built = this.buildTestCase(testCase, classBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.context.getPackageName(), (TypeSpec)classBuilder.build()).skipJavaLangImports(true);
        if (built) {
            this.buildStaticImports(testCase, javaFileBuilder);
        }
        return javaFileBuilder.build();
    }

    @Override
    public List<JavaFile> generateFramework() {
        LinkedList<JavaFile> framework = new LinkedList<JavaFile>();
        framework.add(this.buildType(new AbstractTestCase()));
        framework.add(this.buildType(new CallActivityParseListener()));
        framework.add(this.buildType(new CallActivityRule()));
        framework.add(this.buildType(new BpmndtPlugin()));
        if (this.context.isSpringEnabled()) {
            framework.add(this.buildType(new BpmndtConfiguration()));
        }
        return framework;
    }
}

