/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl.generation;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.extension.bpmndt.GeneratorContext;
import org.camunda.bpm.extension.bpmndt.impl.generation.AssertThatPi;
import org.camunda.bpm.extension.bpmndt.impl.generation.BuildProcessEngine;
import org.camunda.bpm.extension.bpmndt.impl.generation.BuildProcessEngineConfiguration;
import org.camunda.bpm.extension.bpmndt.impl.generation.FindEventSubscription;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

public class AbstractTestCase
implements Function<GeneratorContext, TypeSpec> {
    @Override
    public TypeSpec apply(GeneratorContext context) {
        FieldSpec processEngineRule = context.isSpringEnabled() ? this.buildProcessEngineRuleFieldSpringEnabled() : this.buildProcessEngineRuleField();
        ClassName callActivityRuleType = ClassName.get((String)context.getPackageName(), (String)"CallActivityRule", (String[])new String[0]);
        FieldSpec callActivityRule = FieldSpec.builder((TypeName)callActivityRuleType, (String)"callActivityRule", (Modifier[])new Modifier[]{Modifier.PUBLIC}).addAnnotation(Rule.class).initializer("new $T()", new Object[]{callActivityRuleType}).build();
        FieldSpec processInstance = FieldSpec.builder(ProcessInstance.class, (String)"pi", (Modifier[])new Modifier[]{Modifier.PROTECTED}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"AbstractTestCase");
        if (context.isSpringEnabled()) {
            builder.addAnnotation(this.buildRunWithSpringRunnerAnnotation());
            builder.addAnnotation(this.buildContextConfigurationAnnotation(context));
        }
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        builder.addField(processEngineRule);
        builder.addField(callActivityRule);
        builder.addField(processInstance);
        if (!context.isSpringEnabled()) {
            builder.addMethod(new BuildProcessEngine().apply(context));
            builder.addMethod(new BuildProcessEngineConfiguration().apply(context));
        }
        builder.addMethod(new AssertThatPi().get());
        builder.addMethod(new FindEventSubscription().get());
        return builder.build();
    }

    protected AnnotationSpec buildContextConfigurationAnnotation(GeneratorContext context) {
        TypeName bpmndtConfiguration = context.getTypeName("BpmndtConfiguration");
        return AnnotationSpec.builder(ContextConfiguration.class).addMember("classes", "$T.class", new Object[]{bpmndtConfiguration}).build();
    }

    protected FieldSpec buildProcessEngineRuleField() {
        return FieldSpec.builder(ProcessEngineRule.class, (String)"rule", (Modifier[])new Modifier[]{Modifier.PUBLIC}).addAnnotation(Rule.class).initializer("new $T(buildProcessEngine(), true)", new Object[]{ProcessEngineRule.class}).build();
    }

    protected FieldSpec buildProcessEngineRuleFieldSpringEnabled() {
        return FieldSpec.builder(ProcessEngineRule.class, (String)"rule", (Modifier[])new Modifier[]{Modifier.PUBLIC}).addAnnotation(Autowired.class).addAnnotation(Rule.class).build();
    }

    protected AnnotationSpec buildRunWithSpringRunnerAnnotation() {
        return AnnotationSpec.builder(RunWith.class).addMember("value", "$T.class", new Object[]{SpringRunner.class}).build();
    }
}

