/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl.generation;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.spring.SpringExpressionManager;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.extension.bpmndt.GeneratorContext;
import org.camunda.spin.plugin.impl.SpinProcessEnginePlugin;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class BpmndtConfiguration
implements Function<GeneratorContext, TypeSpec> {
    @Override
    public TypeSpec apply(GeneratorContext context) {
        FieldSpec applicationContext = FieldSpec.builder(ApplicationContext.class, (String)"applicationContext", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Autowired.class).build();
        FieldSpec dataSource = FieldSpec.builder(DataSource.class, (String)"dataSource", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(Autowired.class).addMember("required", "false", new Object[0]).build()).build();
        FieldSpec transactionManager = FieldSpec.builder(PlatformTransactionManager.class, (String)"transactionManager", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(Autowired.class).addMember("required", "false", new Object[0]).build()).build();
        Object[] newArgs = new Object[]{SpringProcessEngineConfiguration.class, "configuration", SpringProcessEngineConfiguration.class};
        Object[] expressionManagerArgs = new Object[]{"configuration", SpringExpressionManager.class};
        Object[] pluginsArgs = new Object[]{"configuration", Arrays.class, SpinProcessEnginePlugin.class, context.getTypeName("BpmndtPlugin")};
        MethodSpec afterPropertiesSet = MethodSpec.methodBuilder((String)"afterPropertiesSet").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).addStatement("$T dataSource = initDataSource()", new Object[]{DataSource.class}).addStatement("$T transactionManager = initTransactionManager(dataSource)", new Object[]{PlatformTransactionManager.class}).addCode("\n", new Object[0]).addStatement("$T $L = new $T()", newArgs).addStatement("$L.setApplicationContext(applicationContext)", new Object[]{"configuration"}).addStatement("$L.setDataSource(dataSource)", new Object[]{"configuration"}).addStatement("$L.setExpressionManager(new $T(applicationContext, null))", expressionManagerArgs).addStatement("$L.setProcessEngineName($S)", new Object[]{"configuration", "bpmndt"}).addStatement("$L.setProcessEnginePlugins($T.asList(new $T(), new $T()))", pluginsArgs).addStatement("$L.setTransactionManager(transactionManager)", new Object[]{"configuration"}).addCode("\n", new Object[0]).addStatement("$L = $L.buildProcessEngine()", new Object[]{"processEngine", "configuration"}).build();
        MethodSpec initDataSource = MethodSpec.methodBuilder((String)"initDataSource").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(DataSource.class).beginControlFlow("if (dataSource != null)", new Object[0]).addStatement("return dataSource", new Object[0]).endControlFlow().addCode("\n", new Object[0]).addStatement("$T dataSource = new $T()", new Object[]{BasicDataSource.class, BasicDataSource.class}).addStatement("dataSource.setDriverClassName($S)", new Object[]{"org.h2.Driver"}).addStatement("dataSource.setUrl($S)", new Object[]{"jdbc:h2:mem:bpmndt;DB_CLOSE_ON_EXIT=FALSE"}).addCode("\n", new Object[0]).addStatement("return dataSource", new Object[0]).build();
        MethodSpec initTransactionManager = MethodSpec.methodBuilder((String)"initTransactionManager").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(PlatformTransactionManager.class).addParameter(DataSource.class, "dataSource", new Modifier[0]).beginControlFlow("if (transactionManager != null)", new Object[0]).addStatement("return transactionManager", new Object[0]).endControlFlow().addCode("\n", new Object[0]).addStatement("return new $T(dataSource)", new Object[]{DataSourceTransactionManager.class}).build();
        MethodSpec getProcessEngine = MethodSpec.methodBuilder((String)"getProcessEngine").addAnnotation(Bean.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ProcessEngine.class).addStatement("return processEngine", new Object[0]).build();
        MethodSpec getProcessEngineRule = MethodSpec.methodBuilder((String)"getProcessEngineRule").addAnnotation(Bean.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ProcessEngineRule.class).addStatement("return new $T(processEngine, true)", new Object[]{ProcessEngineRule.class}).build();
        return TypeSpec.classBuilder((String)"BpmndtConfiguration").addAnnotation(Configuration.class).addSuperinterface(InitializingBean.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(applicationContext).addField(dataSource).addField(transactionManager).addField(ProcessEngine.class, "processEngine", new Modifier[]{Modifier.PRIVATE}).addMethod(afterPropertiesSet).addMethod(initDataSource).addMethod(initTransactionManager).addMethod(getProcessEngine).addMethod(getProcessEngineRule).build();
    }
}

