/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl.generation;

import com.squareup.javapoet.MethodSpec;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.extension.bpmndt.BpmnNode;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.SignalEventDefinition;
import org.camunda.bpm.model.bpmn.instance.TimerEventDefinition;

public class HandleIntermediateCatchEvent
implements Function<BpmnNode, MethodSpec> {
    @Override
    public MethodSpec apply(BpmnNode node) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)node.getLiteral()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        IntermediateCatchEvent event = node.as(IntermediateCatchEvent.class);
        Optional eventDefinition = event.getEventDefinitions().stream().findFirst();
        if (!eventDefinition.isPresent()) {
            builder.addCode("// no event definition found for intermediate catch event $L\n", new Object[]{node.getId()});
        } else if (eventDefinition.get() instanceof MessageEventDefinition) {
            builder.addJavadoc("Overwrite to handle intermediate message catch event $L.", new Object[]{node.getId()});
            builder.addParameter(EventSubscription.class, "subscription", new Modifier[0]);
            Object[] args = new Object[]{"rule", "subscription", "subscription"};
            builder.addStatement("$L.getRuntimeService().messageEventReceived($L.getEventName(), $L.getExecutionId())", args);
        } else if (eventDefinition.get() instanceof SignalEventDefinition) {
            builder.addJavadoc("Overwrite to handle intermediate signal catch event $L.", new Object[]{node.getId()});
            builder.addParameter(EventSubscription.class, "subscription", new Modifier[0]);
            Object[] args = new Object[]{"rule", "subscription", "subscription"};
            builder.addStatement("$L.getRuntimeService().signalEventReceived($L.getEventName(), $L.getExecutionId())", args);
        } else if (eventDefinition.get() instanceof TimerEventDefinition) {
            builder.addJavadoc("Overwrite to handle intermediate timer catch event $L.", new Object[]{node.getId()});
            builder.addParameter(Job.class, "job", new Modifier[0]);
            builder.addStatement("$L.getManagementService().executeJob($L.getId())", new Object[]{"rule", "job"});
        } else {
            builder.addJavadoc("Overwrite to handle intermediate catch event $L", new Object[]{node.getId()});
        }
        return builder.build();
    }
}

