/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl.generation;

import com.squareup.javapoet.CodeBlock;
import java.util.Optional;
import java.util.function.Function;
import org.camunda.bpm.extension.bpmndt.BpmnNode;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Signal;
import org.camunda.bpm.model.bpmn.instance.SignalEventDefinition;
import org.camunda.bpm.model.bpmn.instance.TimerEventDefinition;

public class HandleIntermediateCatchEventCodeBlock
implements Function<BpmnNode, CodeBlock> {
    @Override
    public CodeBlock apply(BpmnNode node) {
        IntermediateCatchEvent event = node.as(IntermediateCatchEvent.class);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("assertThat($L).isWaitingAt($S)", new Object[]{"pi", node.getId()});
        Optional eventDefinition = event.getEventDefinitions().stream().findFirst();
        if (!eventDefinition.isPresent()) {
            builder.add("// no event definition found for intermediate message catch event $L\n", new Object[]{node.getId()});
        } else if (eventDefinition.get() instanceof MessageEventDefinition) {
            Message message = ((MessageEventDefinition)eventDefinition.get()).getMessage();
            this.handleEventSubscription(builder, node, message != null ? message.getName() : null);
        } else if (eventDefinition.get() instanceof SignalEventDefinition) {
            Signal signal = ((SignalEventDefinition)eventDefinition.get()).getSignal();
            this.handleEventSubscription(builder, node, signal != null ? signal.getName() : null);
        } else if (eventDefinition.get() instanceof TimerEventDefinition) {
            builder.addStatement("$L(job($S, $L))", new Object[]{node.getLiteral(), node.getId(), "pi"});
        } else {
            builder.add("// unsupported intermediate catch event $L\n", new Object[]{node.getId()});
        }
        return builder.build();
    }

    protected void handleEventSubscription(CodeBlock.Builder builder, BpmnNode node, String eventName) {
        Object[] args = new Object[]{node.getLiteral(), "findEventSubscription", node.getId(), eventName};
        builder.addStatement("$L($L($S, $S))", args);
    }
}

