/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.bpmndt.impl.generation;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import java.util.function.BiFunction;
import javax.lang.model.element.Modifier;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.assertions.ProcessEngineTests;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.extension.bpmndt.BpmnNode;
import org.camunda.bpm.extension.bpmndt.BpmnSupport;
import org.camunda.bpm.extension.bpmndt.GeneratorContext;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleAsyncAfterCodeBlock;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleAsyncBeforeCodeBlock;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleExternalTaskCodeBlock;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleIntermediateCatchEventCodeBlock;
import org.camunda.bpm.extension.bpmndt.impl.generation.HandleUserTaskCodeBlock;
import org.camunda.bpm.extension.bpmndt.type.Path;
import org.camunda.bpm.extension.bpmndt.type.TestCase;
import org.junit.Test;

public class TestMethod
implements BiFunction<GeneratorContext, TestCase, MethodSpec> {
    @Override
    public MethodSpec apply(GeneratorContext context, TestCase testCase) {
        BpmnNode node;
        BpmnSupport bpmnSupport = context.getBpmnSupport();
        AnnotationSpec deploymentAnnotation = AnnotationSpec.builder(Deployment.class).addMember("resources", "{$S}", new Object[]{context.getBpmnResourceName()}).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"testPath").addAnnotation(Test.class).addAnnotation(deploymentAnnotation).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("$T.init($L.getProcessEngine())", new Object[]{ProcessEngineTests.class, "rule"}).addCode("\n// register call activity rule at parse listener\n", new Object[0]).addStatement("$L.register($L)", new Object[]{"callActivityRule", "rule"});
        Path path = testCase.getPath();
        for (String flowNodeId : path.getFlowNodeIds()) {
            node = bpmnSupport.get(flowNodeId);
            if (!node.isCallActivity()) continue;
            builder.addCode("\n// $L: $L\n", new Object[]{node.getType(), node.getId()});
            Object[] args = new Object[]{"callActivityRule", node.getId(), node.getLiteral()};
            builder.addStatement("$L.callbackI.put($S, this::$L_input)", args);
            builder.addStatement("$L.callbackO.put($S, this::$L_output)", args);
        }
        builder.addCode("\n", new Object[0]).addStatement("$T $L = $T.createVariables()", new Object[]{VariableMap.class, "variables", Variables.class}).addStatement("$T $L = $L($L)", new Object[]{String.class, "businessKey", "before", "variables"}).addCode("\n", new Object[0]).addCode("$L = $L.getRuntimeService()\n", new Object[]{"pi", "rule"}).addCode("    .createProcessInstanceByKey($S)\n", new Object[]{bpmnSupport.getProcessId()}).addCode("    .businessKey($L)", new Object[]{"businessKey"}).addCode("    .setVariables($L)\n", new Object[]{"variables"}).addCode("    .startBeforeActivity($S)\n", new Object[]{path.getStart()}).addCode("    .execute();\n\n", new Object[0]).addStatement("assertThat($L).isStarted()", new Object[]{"pi"});
        for (String flowNodeId : path.getFlowNodeIds()) {
            node = bpmnSupport.get(flowNodeId);
            builder.addCode("\n// $L: $L\n", new Object[]{node.getType(), node.getId()});
            if (node.isAsyncBefore()) {
                builder.addCode(new HandleAsyncBeforeCodeBlock().apply(node));
            }
            if (node.isExternalTask()) {
                builder.addCode(new HandleExternalTaskCodeBlock().apply(node));
            }
            if (node.isIntermediateCatchEvent()) {
                builder.addCode(new HandleIntermediateCatchEventCodeBlock().apply(node));
            }
            if (node.isUserTask()) {
                builder.addCode(new HandleUserTaskCodeBlock().apply(node));
            }
            if (node.isAsyncAfter()) {
                builder.addCode(new HandleAsyncAfterCodeBlock().apply(node));
            }
            builder.addStatement("assertThat($L).hasPassed($S)", new Object[]{"pi", flowNodeId});
        }
        builder.addCode("\n", new Object[0]);
        builder.addStatement("$L()", new Object[]{"after"});
        return builder.build();
    }
}

