/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import java.util.Objects;
import org.camunda.community.bpmndt.model.BpmnElement;
import org.camunda.community.bpmndt.model.BpmnElementScope;
import org.camunda.community.bpmndt.model.BpmnElementType;

class BpmnElementImpl
implements BpmnElement {
    FlowNode flowNode;
    MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
    BpmnElementScope parent;
    BpmnElement prev;
    BpmnElement next;
    BpmnElementType type;
    String attachedTo;
    boolean processStart;

    BpmnElementImpl() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BpmnElement)) {
            return false;
        }
        BpmnElement element = (BpmnElement)obj;
        return element.getId().equals(this.getId());
    }

    @Override
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Override
    public <T extends FlowNode> T getFlowNode(Class<T> flowNodeType) {
        return (T)((FlowNode)flowNodeType.cast(this.flowNode));
    }

    @Override
    public String getId() {
        return this.flowNode.getId();
    }

    @Override
    public String getName() {
        return this.flowNode.getName();
    }

    @Override
    public int getNestingLevel() {
        return this.parent != null ? this.parent.getNestingLevel() : 0;
    }

    @Override
    public BpmnElement getNext() {
        if (!this.hasNext()) {
            throw new IllegalStateException("element has no successors");
        }
        return this.next;
    }

    @Override
    public BpmnElementScope getParent() {
        if (!this.hasParent()) {
            throw new IllegalStateException("element has no parent");
        }
        return this.parent;
    }

    @Override
    public BpmnElement getPrevious() {
        if (!this.hasPrevious()) {
            throw new IllegalStateException("element has no predecessor");
        }
        return this.prev;
    }

    @Override
    public BpmnElementType getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.flowNode.getElementType().getTypeName();
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public boolean hasMultiInstanceParent() {
        return this.hasParent() && this.parent.isMultiInstance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean hasPrevious() {
        return this.prev != null;
    }

    @Override
    public boolean hasPrevious(BpmnElementType type) {
        return this.hasPrevious() && this.getPrevious().getType() == type;
    }

    @Override
    public boolean isAttachedTo(BpmnElement element) {
        return element.getId().equals(this.attachedTo);
    }

    @Override
    public boolean isMultiInstance() {
        return this.multiInstanceLoopCharacteristics != null;
    }

    @Override
    public boolean isMultiInstanceSequential() {
        if (!this.isMultiInstance()) {
            throw new IllegalStateException("element is not a multi instance");
        }
        return this.multiInstanceLoopCharacteristics.isSequential();
    }

    @Override
    public boolean isProcessStart() {
        return this.processStart;
    }
}

