/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class BpmnSupport {
    private final Map<String, FlowNode> flowNodes;
    private final Process process;

    public BpmnSupport(Process process) {
        this.process = process;
        LinkedList<FlowNode> flowNodes = new LinkedList<FlowNode>();
        this.collect(flowNodes, process.getFlowElements());
        this.collectSubProcesses(flowNodes, process.getChildElementsByType(SubProcess.class));
        this.flowNodes = flowNodes.stream().collect(Collectors.toMap(BaseElement::getId, Function.identity()));
    }

    public FlowNode get(String flowNodeId) {
        return this.flowNodes.get(flowNodeId);
    }

    public MultiInstanceLoopCharacteristics getMultiInstanceLoopCharacteristics(String flowNodeId) {
        if (!this.has(flowNodeId)) {
            return null;
        }
        FlowNode flowNode = this.flowNodes.get(flowNodeId);
        if (!(flowNode instanceof Activity)) {
            return null;
        }
        Activity activity = (Activity)flowNode;
        if (activity.getLoopCharacteristics() == null) {
            return null;
        }
        if (!(activity.getLoopCharacteristics() instanceof MultiInstanceLoopCharacteristics)) {
            return null;
        }
        return (MultiInstanceLoopCharacteristics)activity.getLoopCharacteristics();
    }

    public String getParentElementId(String flowNodeId) {
        FlowNode flowNode = this.flowNodes.get(flowNodeId);
        if (flowNode == null) {
            return null;
        }
        if (flowNode.getParentElement() == null) {
            return null;
        }
        try {
            return ((BaseElement)flowNode.getParentElement()).getId();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean has(String flowNodeId) {
        return this.flowNodes.containsKey(flowNodeId);
    }

    public boolean isBoundaryEvent(String flowNodeId) {
        return this.is(flowNodeId, "boundaryEvent");
    }

    public boolean isBusinessRuleTask(String flowNodeId) {
        return this.is(flowNodeId, "businessRuleTask");
    }

    public boolean isCallActivity(String flowNodeId) {
        return this.is(flowNodeId, "callActivity");
    }

    public boolean isEndEvent(String flowNodeId) {
        return this.is(flowNodeId, "endEvent");
    }

    public boolean isEventBasedGateway(String flowNodeId) {
        return this.is(flowNodeId, "eventBasedGateway");
    }

    public boolean isIntermediateCatchEvent(String flowNodeId) {
        return this.is(flowNodeId, "intermediateCatchEvent");
    }

    public boolean isIntermediateThrowEvent(String flowNodeId) {
        return this.is(flowNodeId, "intermediateThrowEvent");
    }

    public boolean isProcessEnd(String flowNodeId) {
        if (!this.is(flowNodeId, "endEvent")) {
            return false;
        }
        ModelElementInstance parent = this.flowNodes.get(flowNodeId).getParentElement();
        if (parent == null) {
            return false;
        }
        return parent.getElementType().getTypeName().equals("process");
    }

    public boolean isProcessStart(String flowNodeId) {
        if (!this.is(flowNodeId, "startEvent")) {
            return false;
        }
        ModelElementInstance parent = this.flowNodes.get(flowNodeId).getParentElement();
        if (parent == null) {
            return false;
        }
        return parent.getElementType().getTypeName().equals("process");
    }

    public boolean isReceiveTask(String flowNodeId) {
        return this.is(flowNodeId, "receiveTask");
    }

    public boolean isScriptTask(String flowNodeId) {
        return this.is(flowNodeId, "scriptTask");
    }

    public boolean isSendTask(String flowNodeId) {
        return this.is(flowNodeId, "sendTask");
    }

    public boolean isServiceTask(String flowNodeId) {
        return this.is(flowNodeId, "serviceTask");
    }

    public boolean isUserTask(String flowNodeId) {
        return this.is(flowNodeId, "userTask");
    }

    private void collect(List<FlowNode> flowNodes, Collection<FlowElement> elements) {
        elements.stream().filter(this::isFlowNode).map(FlowNode.class::cast).forEach(flowNodes::add);
    }

    private void collectSubProcesses(List<FlowNode> flowNodes, Collection<SubProcess> subProcesses) {
        for (SubProcess subProcess : subProcesses) {
            this.collect(flowNodes, subProcess.getFlowElements());
            this.collectSubProcesses(flowNodes, subProcess.getChildElementsByType(SubProcess.class));
        }
    }

    private boolean is(String flowNodeId, String typeName) {
        FlowNode flowNode = this.flowNodes.get(flowNodeId);
        return flowNode != null && flowNode.getElementType().getTypeName().equals(typeName);
    }

    private boolean isFlowNode(FlowElement element) {
        return FlowNode.class.isAssignableFrom(element.getClass());
    }
}

