/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.instance.Process;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.community.bpmndt.model.BpmnElement;
import org.camunda.community.bpmndt.model.BpmnElementImpl;
import org.camunda.community.bpmndt.model.BpmnElementScopeImpl;
import org.camunda.community.bpmndt.model.TestCase;
import org.camunda.community.bpmndt.model.element.TestCaseElement;

class TestCaseImpl
implements TestCase {
    TestCaseElement element;
    Process process;
    private final LinkedList<BpmnElement> elements = new LinkedList();
    private final List<String> invalidElementIds = new LinkedList<String>();
    private final Map<String, BpmnElementScopeImpl> scopes = new LinkedHashMap<String, BpmnElementScopeImpl>();
    private BpmnElementImpl prev;

    TestCaseImpl() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TestCase)) {
            return false;
        }
        TestCase testCase = (TestCase)obj;
        return testCase.getProcessId().equals(this.getProcessId()) && testCase.getName().equals(this.getName());
    }

    @Override
    public String getDescription() {
        return this.element.getDescription();
    }

    @Override
    public BpmnElement getEndElement() {
        if (this.elements.isEmpty()) {
            throw new IllegalStateException("path is empty");
        }
        return this.elements.get(this.elements.size() - 1);
    }

    @Override
    public List<BpmnElement> getElements() {
        return this.elements;
    }

    @Override
    public List<String> getElementIds() {
        return this.element.getPath().getFlowNodeIds();
    }

    @Override
    public List<String> getInvalidElementIds() {
        return this.invalidElementIds;
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public String getProcessId() {
        return this.process.getId();
    }

    @Override
    public String getProcessName() {
        return this.process.getName();
    }

    @Override
    public BpmnElement getStartElement() {
        if (this.elements.isEmpty()) {
            throw new IllegalStateException("path is empty");
        }
        return this.elements.get(0);
    }

    public int hashCode() {
        return Objects.hash(this.getProcessId(), this.getName());
    }

    @Override
    public boolean hasEmptyPath() {
        return this.getElementIds().isEmpty();
    }

    @Override
    public boolean hasIncompletePath() {
        return this.getElementIds().size() == 1;
    }

    @Override
    public boolean hasInvalidPath() {
        return !this.invalidElementIds.isEmpty();
    }

    @Override
    public boolean isValid() {
        return !this.hasEmptyPath() && !this.hasIncompletePath() && !this.hasInvalidPath();
    }

    void addElement(BpmnElementImpl next) {
        if (this.prev != null) {
            this.prev.next = next;
            next.prev = this.prev;
        }
        this.elements.add(next);
        this.prev = next;
    }

    void addScope(BpmnElementScopeImpl scope) {
        this.scopes.put(scope.getId(), scope);
    }

    void addInvalidElementId(String elementId) {
        this.invalidElementIds.add(elementId);
    }

    BpmnElementScopeImpl getScope(String scopeId) {
        return this.scopes.get(scopeId);
    }
}

