/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Definitions;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.ThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.ModelParseException;
import org.camunda.community.bpmndt.model.BpmnElementImpl;
import org.camunda.community.bpmndt.model.BpmnElementScopeImpl;
import org.camunda.community.bpmndt.model.BpmnElementType;
import org.camunda.community.bpmndt.model.BpmnEventSupport;
import org.camunda.community.bpmndt.model.BpmnExtension;
import org.camunda.community.bpmndt.model.BpmnSupport;
import org.camunda.community.bpmndt.model.TestCase;
import org.camunda.community.bpmndt.model.TestCaseImpl;
import org.camunda.community.bpmndt.model.TestCases;
import org.camunda.community.bpmndt.model.element.TestCaseElement;
import org.camunda.community.bpmndt.model.element.TestCasesElement;

class TestCasesImpl
implements TestCases {
    final BpmnModelInstance modelInstance;
    private final Set<String> processIds;
    private final List<TestCase> testCases;
    private BpmnSupport bpmnSupport;

    static TestCasesImpl of(InputStream stream) {
        try {
            return TestCasesImpl.of(BpmnExtension.readModelFromStream(stream));
        }
        catch (ModelParseException e) {
            throw new RuntimeException("BPMN model could not be parsed", e);
        }
    }

    static TestCasesImpl of(BpmnModelInstance modelInstance) {
        return new TestCasesImpl(modelInstance).map();
    }

    static TestCasesImpl of(Path bpmnFile) {
        TestCasesImpl testCasesImpl;
        FileInputStream fis = new FileInputStream(bpmnFile.toFile());
        try {
            testCasesImpl = TestCasesImpl.of(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("BPMN file could not be found", e);
            }
            catch (IOException e) {
                throw new RuntimeException("BPMN file could not be read", e);
            }
        }
        fis.close();
        return testCasesImpl;
    }

    TestCasesImpl(BpmnModelInstance modelInstance) {
        this.modelInstance = modelInstance;
        this.processIds = new TreeSet<String>();
        this.testCases = new LinkedList<TestCase>();
    }

    @Override
    public List<TestCase> get() {
        return this.testCases;
    }

    @Override
    public List<TestCase> get(String processId) {
        return this.testCases.stream().filter(testCase -> testCase.getProcessId().equals(processId)).collect(Collectors.toList());
    }

    @Override
    public BpmnModelInstance getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public Set<String> getProcessIds() {
        return this.processIds;
    }

    @Override
    public boolean isEmpty() {
        return this.testCases.isEmpty();
    }

    @Override
    public boolean isPlatform8() {
        if (this.modelInstance.getDefinitions() == null) {
            return false;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        if (definitions.getDomElement() == null) {
            return false;
        }
        String modelerExecutionPlatform = definitions.getDomElement().getAttribute("http://camunda.org/schema/modeler/1.0", "executionPlatform");
        return "Camunda Cloud".equals(modelerExecutionPlatform);
    }

    List<TestCaseElement> getTestCaseElements(Process process) {
        if (process.getExtensionElements() == null) {
            return Collections.emptyList();
        }
        TestCasesElement testCasesElement = (TestCasesElement)process.getExtensionElements().getUniqueChildElementByType(TestCasesElement.class);
        if (testCasesElement == null) {
            return Collections.emptyList();
        }
        return testCasesElement.getTestCases();
    }

    private void addElement(TestCaseImpl testCase, BpmnElementImpl next) {
        testCase.addElement(next);
        BpmnElementScopeImpl scope = this.addScope(testCase, next.getId());
        if (scope != null) {
            scope.addElement(next);
        }
    }

    private BpmnElementScopeImpl addScope(TestCaseImpl testCase, String elementId) {
        String parentElementId = this.bpmnSupport.getParentElementId(elementId);
        if (testCase.getProcessId().equals(parentElementId)) {
            return null;
        }
        BpmnElementScopeImpl scope = testCase.getScope(parentElementId);
        if (scope == null) {
            scope = new BpmnElementScopeImpl();
            scope.flowNode = this.bpmnSupport.get(parentElementId);
            scope.multiInstanceLoopCharacteristics = this.bpmnSupport.getMultiInstanceLoopCharacteristics(parentElementId);
            testCase.addScope(scope);
            scope.parent = this.addScope(testCase, scope.getId());
        }
        return scope;
    }

    private void handleBoundaryEvent(BpmnElementImpl element) {
        BoundaryEvent event = element.getFlowNode(BoundaryEvent.class);
        BpmnEventSupport eventSupport = new BpmnEventSupport((CatchEvent)event);
        element.attachedTo = event.getAttachedTo().getId();
        element.type = eventSupport.isError() ? BpmnElementType.ERROR_BOUNDARY : (eventSupport.isEscalation() ? BpmnElementType.ESCALATION_BOUNDARY : (eventSupport.isMessage() ? BpmnElementType.MESSAGE_BOUNDARY : (eventSupport.isSignal() ? BpmnElementType.SIGNAL_BOUNDARY : (eventSupport.isTimer() ? BpmnElementType.TIMER_BOUNDARY : BpmnElementType.OTHER))));
    }

    private void handleEndEvent(BpmnElementImpl element) {
        EndEvent event = element.getFlowNode(EndEvent.class);
        BpmnEventSupport eventSupport = new BpmnEventSupport((ThrowEvent)event);
        element.type = eventSupport.isMessage() ? BpmnElementType.SERVICE_TASK : BpmnElementType.OTHER;
    }

    private void handleIntermediateCatchEvent(BpmnElementImpl element) {
        IntermediateCatchEvent event = element.getFlowNode(IntermediateCatchEvent.class);
        BpmnEventSupport eventSupport = new BpmnEventSupport((CatchEvent)event);
        element.type = eventSupport.isMessage() ? BpmnElementType.MESSAGE_CATCH : (eventSupport.isSignal() ? BpmnElementType.SIGNAL_CATCH : (eventSupport.isTimer() ? BpmnElementType.TIMER_CATCH : BpmnElementType.OTHER));
    }

    private void handleIntermediateThrowEvent(BpmnElementImpl element) {
        IntermediateThrowEvent event = element.getFlowNode(IntermediateThrowEvent.class);
        BpmnEventSupport eventSupport = new BpmnEventSupport((ThrowEvent)event);
        element.type = eventSupport.isLink() ? BpmnElementType.LINK_THROW : (eventSupport.isMessage() ? BpmnElementType.SERVICE_TASK : BpmnElementType.OTHER);
    }

    private void handleTask(BpmnElementImpl element) {
        FlowNode flowNode = element.getFlowNode();
        ExtensionElements extensionElements = flowNode.getExtensionElements();
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)extensionElements.getUniqueChildElementByType(ZeebeTaskDefinition.class);
        if (taskDefinition == null) {
            element.type = BpmnElementType.OTHER;
            return;
        }
        String modelerTemplate = flowNode.getDomElement().getAttribute("http://camunda.org/schema/zeebe/1.0", "modelerTemplate");
        element.type = modelerTemplate != null && !modelerTemplate.isBlank() ? BpmnElementType.OUTBOUND_CONNECTOR : BpmnElementType.SERVICE_TASK;
    }

    private TestCasesImpl map() {
        this.modelInstance.getDefinitions().getChildElementsByType(Process.class).forEach(this::map);
        return this;
    }

    private void map(Process process) {
        this.processIds.add(process.getId());
        this.bpmnSupport = new BpmnSupport(process);
        this.getTestCaseElements(process).stream().map(this::mapTestCase).forEach(this.testCases::add);
        this.bpmnSupport = null;
    }

    private TestCase mapTestCase(TestCaseElement testCaseElement) {
        TestCaseImpl testCase = new TestCaseImpl();
        testCase.element = testCaseElement;
        testCase.process = this.bpmnSupport.getProcess();
        if (testCaseElement.getPath() == null) {
            return testCase;
        }
        List<String> flowNodeIds = testCaseElement.getPath().getFlowNodeIds();
        for (int i = 0; i < flowNodeIds.size(); ++i) {
            String flowNodeId = flowNodeIds.get(i);
            if (!this.bpmnSupport.has(flowNodeId)) {
                testCase.addInvalidElementId(flowNodeId);
                continue;
            }
            BpmnElementImpl element = new BpmnElementImpl();
            element.flowNode = this.bpmnSupport.get(flowNodeId);
            element.multiInstanceLoopCharacteristics = this.bpmnSupport.getMultiInstanceLoopCharacteristics(flowNodeId);
            if (this.bpmnSupport.isCallActivity(flowNodeId)) {
                element.type = BpmnElementType.CALL_ACTIVITY;
            } else if (this.bpmnSupport.isEventBasedGateway(flowNodeId)) {
                element.type = BpmnElementType.EVENT_BASED_GATEWAY;
            } else if (this.bpmnSupport.isServiceTask(flowNodeId)) {
                this.handleTask(element);
            } else if (this.bpmnSupport.isUserTask(flowNodeId)) {
                element.type = BpmnElementType.USER_TASK;
            } else if (this.bpmnSupport.isIntermediateCatchEvent(flowNodeId)) {
                this.handleIntermediateCatchEvent(element);
            } else if (this.bpmnSupport.isBoundaryEvent(flowNodeId)) {
                this.handleBoundaryEvent(element);
            } else if (this.bpmnSupport.isIntermediateThrowEvent(flowNodeId)) {
                this.handleIntermediateThrowEvent(element);
            } else if (this.bpmnSupport.isEndEvent(flowNodeId)) {
                this.handleEndEvent(element);
            } else if (this.bpmnSupport.isBusinessRuleTask(flowNodeId)) {
                this.handleTask(element);
            } else if (this.bpmnSupport.isSendTask(flowNodeId)) {
                this.handleTask(element);
            } else if (this.bpmnSupport.isReceiveTask(flowNodeId)) {
                element.type = BpmnElementType.RECEIVE_TASK;
            } else if (this.bpmnSupport.isScriptTask(flowNodeId)) {
                this.handleTask(element);
            } else {
                element.type = BpmnElementType.OTHER;
            }
            if (i == 0) {
                element.processStart = this.bpmnSupport.isProcessStart(flowNodeId);
            }
            this.addElement(testCase, element);
        }
        return testCase;
    }
}

