/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.camunda.community.bpmndt.model.BpmnElement;
import org.camunda.community.bpmndt.model.BpmnElementImpl;
import org.camunda.community.bpmndt.model.BpmnElementScope;
import org.camunda.community.bpmndt.model.BpmnElementType;

class BpmnElementScopeImpl
implements BpmnElementScope {
    FlowNode flowNode;
    MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
    BpmnElementScope parent;
    private final List<BpmnElement> elements = new LinkedList<BpmnElement>();

    BpmnElementScopeImpl() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BpmnElementScope)) {
            return false;
        }
        BpmnElementScope scope = (BpmnElementScope)obj;
        return scope.getId().equals(this.getId());
    }

    @Override
    public List<BpmnElement> getElements() {
        return this.elements;
    }

    @Override
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Override
    public <T extends FlowNode> T getFlowNode(Class<T> flowNodeType) {
        return (T)((FlowNode)flowNodeType.cast(this.flowNode));
    }

    @Override
    public String getId() {
        return this.flowNode.getId();
    }

    @Override
    public String getName() {
        return this.flowNode.getName();
    }

    @Override
    public int getNestingLevel() {
        return this.parent != null ? this.parent.getNestingLevel() + 1 : 1;
    }

    @Override
    public BpmnElement getNext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BpmnElementScope getParent() {
        return this.parent;
    }

    @Override
    public BpmnElement getPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BpmnElementType getType() {
        return BpmnElementType.SCOPE;
    }

    @Override
    public String getTypeName() {
        return this.flowNode.getElementType().getTypeName();
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public boolean hasMultiInstanceParent() {
        return this.hasParent() && this.getParent().isMultiInstance();
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public boolean hasPrevious(BpmnElementType type) {
        return false;
    }

    @Override
    public boolean isAttachedTo(BpmnElement element) {
        return false;
    }

    @Override
    public boolean isMultiInstance() {
        return this.multiInstanceLoopCharacteristics != null;
    }

    @Override
    public boolean isMultiInstanceSequential() {
        if (!this.isMultiInstance()) {
            throw new IllegalStateException("scope is not a multi instance");
        }
        return this.multiInstanceLoopCharacteristics.isSequential();
    }

    @Override
    public boolean isProcessStart() {
        return false;
    }

    void addElement(BpmnElementImpl next) {
        this.elements.add(next);
        next.parent = this;
    }
}

