/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Collection;

public class BpmnEventSupport {
    private final EventDefinition eventDefinition;
    private ThrowEvent throwEvent;

    public BpmnEventSupport(CatchEvent event) {
        this(event.getEventDefinitions());
    }

    public BpmnEventSupport(ThrowEvent event) {
        this(event.getEventDefinitions());
        this.throwEvent = event;
    }

    private BpmnEventSupport(Collection<EventDefinition> eventDefinitions) {
        this.eventDefinition = eventDefinitions.stream().findFirst().orElse(null);
    }

    public String getErrorCode() {
        ErrorEventDefinition errorEventDefinition = this.getErrorDefinition();
        if (errorEventDefinition != null) {
            Error error = errorEventDefinition.getError();
            return error != null ? error.getErrorCode() : null;
        }
        return null;
    }

    public ErrorEventDefinition getErrorDefinition() {
        return (ErrorEventDefinition)this.eventDefinition;
    }

    public String getEscalationCode() {
        EscalationEventDefinition escalationEventDefinition = this.getEscalationDefinition();
        if (escalationEventDefinition != null) {
            Escalation escalation = escalationEventDefinition.getEscalation();
            return escalation != null ? escalation.getEscalationCode() : null;
        }
        return null;
    }

    public EscalationEventDefinition getEscalationDefinition() {
        return (EscalationEventDefinition)this.eventDefinition;
    }

    public MessageEventDefinition getMessageDefinition() {
        return (MessageEventDefinition)this.eventDefinition;
    }

    public SignalEventDefinition getSignalDefinition() {
        return (SignalEventDefinition)this.eventDefinition;
    }

    public TimerEventDefinition getTimerDefinition() {
        return (TimerEventDefinition)this.eventDefinition;
    }

    private boolean is(String typeName) {
        if (this.eventDefinition != null) {
            return this.eventDefinition.getElementType().getTypeName().equals(typeName);
        }
        return false;
    }

    public boolean isError() {
        return this.is("errorEventDefinition");
    }

    public boolean isEscalation() {
        return this.is("escalationEventDefinition");
    }

    public boolean isLink() {
        return this.is("linkEventDefinition");
    }

    public boolean isMessage() {
        return this.is("messageEventDefinition");
    }

    public boolean isSignal() {
        return this.is("signalEventDefinition");
    }

    public boolean isTimer() {
        return this.is("timerEventDefinition");
    }
}

