/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.BpmnImpl;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.impl.BpmnParser;
import java.io.InputStream;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.impl.ModelImpl;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.community.bpmndt.model.element.DescriptionElement;
import org.camunda.community.bpmndt.model.element.NameElement;
import org.camunda.community.bpmndt.model.element.PathElement;
import org.camunda.community.bpmndt.model.element.PathNodeElement;
import org.camunda.community.bpmndt.model.element.TestCaseElement;
import org.camunda.community.bpmndt.model.element.TestCasesElement;

public final class BpmnExtension {
    public static final String ELEMENT_DESCRIPTION = "description";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_NODE = "node";
    public static final String ELEMENT_PATH = "path";
    public static final String ELEMENT_TEST_CASE = "testCase";
    public static final String ELEMENT_TEST_CASES = "testCases";
    public static final String MODELER_EXECUTION_PLATFORM = "Camunda Cloud";
    public static final String MODELER_EXECUTION_PLATFORM_ATTRIBUTE = "executionPlatform";
    public static final String MODELER_NS = "http://camunda.org/schema/modeler/1.0";
    public static final String ZEEBE_MODELER_TEMPLATE_ATTRIBUTE = "modelerTemplate";
    public static final String ZEEBE_NS = "http://camunda.org/schema/zeebe/1.0";
    public static final String NS = "http://camunda.org/schema/extension/bpmn-driven-testing";
    private static final CustomBpmn INSTANCE = new CustomBpmn();
    private static final CustomBpmnParser PARSER_INSTANCE = new CustomBpmnParser();

    public static BpmnModelInstance readModelFromStream(InputStream stream) {
        return PARSER_INSTANCE.parseModelFromStream(stream);
    }

    private BpmnExtension() {
    }

    private static class CustomBpmnParser
    extends BpmnParser {
        private CustomBpmnParser() {
        }

        protected BpmnModelInstanceImpl createModelInstance(DomDocument document) {
            return new BpmnModelInstanceImpl((ModelImpl)INSTANCE.getBpmnModel(), INSTANCE.getBpmnModelBuilder(), document);
        }
    }

    private static class CustomBpmn
    extends BpmnImpl {
        private CustomBpmn() {
        }

        protected void doRegisterTypes(ModelBuilder modelBuilder) {
            super.doRegisterTypes(modelBuilder);
            TestCasesElement.registerType(modelBuilder);
            TestCaseElement.registerType(modelBuilder);
            DescriptionElement.registerType(modelBuilder);
            NameElement.registerType(modelBuilder);
            PathElement.registerType(modelBuilder);
            PathNodeElement.registerType(modelBuilder);
        }
    }
}

