/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.CatchEvent;
import org.camunda.bpm.model.bpmn.instance.ConditionalEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Error;
import org.camunda.bpm.model.bpmn.instance.ErrorEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Escalation;
import org.camunda.bpm.model.bpmn.instance.EscalationEventDefinition;
import org.camunda.bpm.model.bpmn.instance.EventDefinition;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Signal;
import org.camunda.bpm.model.bpmn.instance.SignalEventDefinition;
import org.camunda.bpm.model.bpmn.instance.ThrowEvent;
import org.camunda.bpm.model.bpmn.instance.TimerEventDefinition;

public class BpmnEventSupport {
    private final EventDefinition eventDefinition;
    private ThrowEvent throwEvent;

    public BpmnEventSupport(CatchEvent event) {
        this(event.getEventDefinitions());
    }

    public BpmnEventSupport(ThrowEvent event) {
        this(event.getEventDefinitions());
        this.throwEvent = event;
    }

    private BpmnEventSupport(Collection<EventDefinition> eventDefinitions) {
        this.eventDefinition = eventDefinitions.stream().findFirst().orElse(null);
    }

    public ConditionalEventDefinition getConditionalDefinition() {
        return (ConditionalEventDefinition)this.eventDefinition;
    }

    public Error getError() {
        return this.getErrorDefinition().getError();
    }

    public ErrorEventDefinition getErrorDefinition() {
        return (ErrorEventDefinition)this.eventDefinition;
    }

    public Escalation getEscalation() {
        return this.getEscalationDefinition().getEscalation();
    }

    public EscalationEventDefinition getEscalationDefinition() {
        return (EscalationEventDefinition)this.eventDefinition;
    }

    public Message getMessage() {
        return this.getMessageDefinition().getMessage();
    }

    public MessageEventDefinition getMessageDefinition() {
        return (MessageEventDefinition)this.eventDefinition;
    }

    public Signal getSignal() {
        return this.getSignalDefinition().getSignal();
    }

    public SignalEventDefinition getSignalDefinition() {
        return (SignalEventDefinition)this.eventDefinition;
    }

    public TimerEventDefinition getTimerDefinition() {
        return (TimerEventDefinition)this.eventDefinition;
    }

    private boolean is(String typeName) {
        if (this.eventDefinition != null) {
            return this.eventDefinition.getElementType().getTypeName().equals(typeName);
        }
        return false;
    }

    public boolean isConditional() {
        return this.is("conditionalEventDefinition");
    }

    public boolean isError() {
        return this.is("errorEventDefinition");
    }

    public boolean isEscalation() {
        return this.is("escalationEventDefinition");
    }

    public boolean isLink() {
        return this.is("linkEventDefinition");
    }

    public boolean isMessage() {
        return this.is("messageEventDefinition");
    }

    public boolean isNoneEnd() {
        if (this.eventDefinition != null) {
            return false;
        }
        return this.throwEvent != null && this.throwEvent.getElementType().getTypeName().equals("endEvent");
    }

    public boolean isSignal() {
        return this.is("signalEventDefinition");
    }

    public boolean isTimer() {
        return this.is("timerEventDefinition");
    }
}

