/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BoundaryEvent;
import org.camunda.bpm.model.bpmn.instance.CatchEvent;
import org.camunda.bpm.model.bpmn.instance.Error;
import org.camunda.bpm.model.bpmn.instance.Escalation;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.ReceiveTask;
import org.camunda.bpm.model.bpmn.instance.Signal;
import org.camunda.bpm.model.bpmn.instance.ThrowEvent;
import org.camunda.bpm.model.xml.ModelParseException;
import org.camunda.community.bpmndt.model.BpmnEventSupport;
import org.camunda.community.bpmndt.model.BpmnExtension;
import org.camunda.community.bpmndt.model.BpmnSupport;
import org.camunda.community.bpmndt.model.TestCase;
import org.camunda.community.bpmndt.model.TestCaseActivityImpl;
import org.camunda.community.bpmndt.model.TestCaseActivityScopeImpl;
import org.camunda.community.bpmndt.model.TestCaseActivityType;
import org.camunda.community.bpmndt.model.TestCaseImpl;
import org.camunda.community.bpmndt.model.TestCases;
import org.camunda.community.bpmndt.model.element.TestCaseElement;
import org.camunda.community.bpmndt.model.element.TestCasesElement;

class TestCasesImpl
implements TestCases {
    protected final BpmnModelInstance modelInstance;
    private final Set<String> processIds;
    private final List<TestCase> testCases;
    private BpmnSupport bpmnSupport;

    static TestCasesImpl of(InputStream stream) {
        try {
            return TestCasesImpl.of(Bpmn.readModelFromStream((InputStream)stream));
        }
        catch (ModelParseException e) {
            throw new RuntimeException("BPMN model could not be parsed", e);
        }
    }

    static TestCasesImpl of(BpmnModelInstance modelInstance) {
        return new TestCasesImpl(modelInstance).map();
    }

    static TestCasesImpl of(Path bpmnFile) {
        TestCasesImpl testCasesImpl;
        FileInputStream fis = new FileInputStream(bpmnFile.toFile());
        try {
            testCasesImpl = TestCasesImpl.of(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("BPMN file could not be found", e);
            }
            catch (IOException e) {
                throw new RuntimeException("BPMN file could not be read", e);
            }
        }
        fis.close();
        return testCasesImpl;
    }

    TestCasesImpl(BpmnModelInstance modelInstance) {
        this.modelInstance = modelInstance;
        this.processIds = new TreeSet<String>();
        this.testCases = new LinkedList<TestCase>();
    }

    private void addActivity(TestCaseImpl testCase, TestCaseActivityImpl next) {
        testCase.addActivity(next);
        TestCaseActivityScopeImpl scope = this.addActivityScope(testCase, next.getId());
        if (scope != null) {
            scope.addActivity(next);
        }
    }

    private TestCaseActivityScopeImpl addActivityScope(TestCaseImpl testCase, String elementId) {
        String parentElementId = this.bpmnSupport.getParentElementId(elementId);
        if (testCase.getProcessId().equals(parentElementId)) {
            return null;
        }
        TestCaseActivityScopeImpl scope = testCase.getActivityScope(parentElementId);
        if (scope == null) {
            scope = new TestCaseActivityScopeImpl();
            scope.flowNode = this.bpmnSupport.get(parentElementId);
            scope.multiInstanceLoopCharacteristics = this.bpmnSupport.getMultiInstanceLoopCharacteristics(parentElementId);
            testCase.addActivityScope(scope);
            scope.parent = this.addActivityScope(testCase, scope.getId());
        }
        return scope;
    }

    @Override
    public List<TestCase> get() {
        return this.testCases;
    }

    @Override
    public List<TestCase> get(String processId) {
        return this.testCases.stream().filter(testCase -> testCase.getProcessId().equals(processId)).collect(Collectors.toList());
    }

    @Override
    public BpmnModelInstance getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public Set<String> getProcessIds() {
        return this.processIds;
    }

    protected List<TestCaseElement> getTestCaseElements(Process process) {
        if (process.getExtensionElements() == null) {
            return Collections.emptyList();
        }
        TestCasesElement testCasesElement = (TestCasesElement)process.getExtensionElements().getUniqueChildElementByType(TestCasesElement.class);
        if (testCasesElement == null) {
            return Collections.emptyList();
        }
        return testCasesElement.getTestCases();
    }

    private void handleBoundaryEvent(TestCaseActivityImpl activity) {
        BoundaryEvent event = activity.getFlowNode(BoundaryEvent.class);
        activity.attachedTo = event.getAttachedTo().getId();
        BpmnEventSupport eventSupport = new BpmnEventSupport((CatchEvent)event);
        if (eventSupport.isConditional()) {
            activity.type = TestCaseActivityType.CONDITIONAL_BOUNDARY;
        } else if (eventSupport.isError()) {
            Error error = eventSupport.getError();
            activity.type = TestCaseActivityType.ERROR_BOUNDARY;
            activity.eventCode = error != null ? error.getErrorCode() : null;
        } else if (eventSupport.isEscalation()) {
            Escalation escalation = eventSupport.getEscalation();
            activity.type = TestCaseActivityType.ESCALATION_BOUNDARY;
            activity.eventCode = escalation != null ? escalation.getEscalationCode() : null;
        } else if (eventSupport.isMessage()) {
            Message message = eventSupport.getMessage();
            activity.type = TestCaseActivityType.MESSAGE_BOUNDARY;
            activity.eventName = message != null ? message.getName() : null;
        } else if (eventSupport.isSignal()) {
            Signal signal = eventSupport.getSignal();
            activity.type = TestCaseActivityType.SIGNAL_BOUNDARY;
            activity.eventName = signal != null ? signal.getName() : null;
        } else {
            activity.type = eventSupport.isTimer() ? TestCaseActivityType.TIMER_BOUNDARY : TestCaseActivityType.OTHER;
        }
    }

    private void handleIntermediateCatchEvent(TestCaseActivityImpl activity) {
        IntermediateCatchEvent event = activity.getFlowNode(IntermediateCatchEvent.class);
        BpmnEventSupport eventSupport = new BpmnEventSupport((CatchEvent)event);
        if (eventSupport.isConditional()) {
            activity.type = TestCaseActivityType.CONDITIONAL_CATCH;
        } else if (eventSupport.isMessage()) {
            Message message = eventSupport.getMessage();
            activity.type = TestCaseActivityType.MESSAGE_CATCH;
            activity.eventName = message != null ? message.getName() : null;
        } else if (eventSupport.isSignal()) {
            Signal signal = eventSupport.getSignal();
            activity.type = TestCaseActivityType.SIGNAL_CATCH;
            activity.eventName = signal != null ? signal.getName() : null;
        } else {
            activity.type = eventSupport.isTimer() ? TestCaseActivityType.TIMER_CATCH : TestCaseActivityType.OTHER;
        }
    }

    private void handleIntermediateThrowEvent(TestCaseActivityImpl activity) {
        IntermediateThrowEvent event = activity.getFlowNode(IntermediateThrowEvent.class);
        BpmnEventSupport eventSupport = new BpmnEventSupport((ThrowEvent)event);
        activity.type = eventSupport.isLink() ? TestCaseActivityType.LINK_THROW : TestCaseActivityType.OTHER;
    }

    @Override
    public boolean isEmpty() {
        return this.testCases.isEmpty();
    }

    private TestCasesImpl map() {
        this.modelInstance.getDefinitions().getChildElementsByType(Process.class).forEach(this::map);
        return this;
    }

    private void map(Process process) {
        this.processIds.add(process.getId());
        this.bpmnSupport = new BpmnSupport(process);
        this.getTestCaseElements(process).stream().map(this::mapTestCase).forEach(this.testCases::add);
        this.bpmnSupport = null;
    }

    private TestCase mapTestCase(TestCaseElement element) {
        TestCaseImpl testCase = new TestCaseImpl();
        testCase.element = element;
        testCase.process = this.bpmnSupport.getProcess();
        if (element.getPath() == null) {
            return testCase;
        }
        List<String> flowNodeIds = element.getPath().getFlowNodeIds();
        for (int i = 0; i < flowNodeIds.size(); ++i) {
            String flowNodeId = flowNodeIds.get(i);
            if (!this.bpmnSupport.has(flowNodeId)) {
                testCase.addInvalidFlowNodeId(flowNodeId);
                continue;
            }
            TestCaseActivityImpl activity = new TestCaseActivityImpl();
            activity.flowNode = this.bpmnSupport.get(flowNodeId);
            activity.multiInstanceLoopCharacteristics = this.bpmnSupport.getMultiInstanceLoopCharacteristics(flowNodeId);
            if (this.bpmnSupport.isCallActivity(flowNodeId)) {
                activity.type = TestCaseActivityType.CALL_ACTIVITY;
            } else if (this.bpmnSupport.isEventBasedGateway(flowNodeId)) {
                activity.type = TestCaseActivityType.EVENT_BASED_GATEWAY;
            } else if (this.bpmnSupport.isExternalTask(flowNodeId)) {
                activity.type = TestCaseActivityType.EXTERNAL_TASK;
                activity.topicName = this.bpmnSupport.getTopicName(flowNodeId);
            } else if (this.bpmnSupport.isUserTask(flowNodeId)) {
                activity.type = TestCaseActivityType.USER_TASK;
            } else if (this.bpmnSupport.isIntermediateCatchEvent(flowNodeId)) {
                this.handleIntermediateCatchEvent(activity);
            } else if (this.bpmnSupport.isBoundaryEvent(flowNodeId)) {
                this.handleBoundaryEvent(activity);
            } else if (this.bpmnSupport.isReceiveTask(flowNodeId)) {
                Message message = activity.getFlowNode(ReceiveTask.class).getMessage();
                activity.type = TestCaseActivityType.RECEIVE_TASK;
                activity.eventName = message != null ? message.getName() : null;
            } else if (this.bpmnSupport.isIntermediateThrowEvent(flowNodeId)) {
                this.handleIntermediateThrowEvent(activity);
            } else {
                activity.type = TestCaseActivityType.OTHER;
            }
            if (i == 0) {
                activity.processStart = this.bpmnSupport.isProcessStart(flowNodeId);
            }
            if (i == flowNodeIds.size() - 1) {
                activity.processEnd = this.bpmnSupport.isProcessEnd(flowNodeId);
            }
            this.addActivity(testCase, activity);
        }
        return testCase;
    }

    static {
        Bpmn.INSTANCE = BpmnExtension.INSTANCE;
    }
}

