/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.community.bpmndt.model.TestCaseActivity;
import org.camunda.community.bpmndt.model.TestCaseActivityImpl;
import org.camunda.community.bpmndt.model.TestCaseActivityScope;

class TestCaseActivityScopeImpl
implements TestCaseActivityScope {
    protected FlowNode flowNode;
    protected MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
    protected TestCaseActivityScope parent;
    private final List<TestCaseActivity> activities = new LinkedList<TestCaseActivity>();

    TestCaseActivityScopeImpl() {
    }

    protected void addActivity(TestCaseActivityImpl next) {
        this.activities.add(next);
        next.parent = this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TestCaseActivityScope)) {
            return false;
        }
        TestCaseActivityScope scope = (TestCaseActivityScope)obj;
        return scope.getId().equals(this.getId());
    }

    @Override
    public List<TestCaseActivity> getActivities() {
        return this.activities;
    }

    @Override
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Override
    public <T extends SubProcess> T getFlowNode(Class<T> subProcessType) {
        return (T)((SubProcess)subProcessType.cast(this.flowNode));
    }

    @Override
    public String getId() {
        return this.flowNode.getId();
    }

    @Override
    public String getName() {
        return this.flowNode.getName();
    }

    @Override
    public int getNestingLevel() {
        return this.parent != null ? this.parent.getNestingLevel() + 1 : 1;
    }

    @Override
    public TestCaseActivityScope getParent() {
        return this.parent;
    }

    @Override
    public String getTypeName() {
        return this.flowNode.getElementType().getTypeName();
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean isMultiInstance() {
        return this.multiInstanceLoopCharacteristics != null;
    }

    @Override
    public boolean isMultiInstanceParallel() {
        return !this.isMultiInstanceSequential();
    }

    @Override
    public boolean isMultiInstanceSequential() {
        if (!this.isMultiInstance()) {
            throw new IllegalStateException("scope is not a multi instance");
        }
        return this.multiInstanceLoopCharacteristics.isSequential();
    }
}

