/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import java.util.Objects;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.community.bpmndt.model.TestCaseActivity;
import org.camunda.community.bpmndt.model.TestCaseActivityScope;
import org.camunda.community.bpmndt.model.TestCaseActivityType;

class TestCaseActivityImpl
implements TestCaseActivity {
    protected FlowNode flowNode;
    protected MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
    protected TestCaseActivityScope parent;
    protected TestCaseActivity prev;
    protected TestCaseActivity next;
    protected TestCaseActivityType type;
    protected String attachedTo;
    protected String eventCode;
    protected String eventName;
    protected String topicName;
    protected boolean processEnd;
    protected boolean processStart;

    TestCaseActivityImpl() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TestCaseActivity)) {
            return false;
        }
        TestCaseActivity activity = (TestCaseActivity)obj;
        return activity.getId().equals(this.getId());
    }

    @Override
    public String getEventCode() {
        return this.eventCode;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Override
    public <T extends FlowNode> T getFlowNode(Class<T> flowNodeType) {
        return (T)((FlowNode)flowNodeType.cast(this.flowNode));
    }

    @Override
    public String getId() {
        return this.flowNode.getId();
    }

    @Override
    public String getName() {
        return this.flowNode.getName();
    }

    @Override
    public int getNestingLevel() {
        return this.parent != null ? this.parent.getNestingLevel() : 0;
    }

    @Override
    public TestCaseActivity getNext() {
        if (!this.hasNext()) {
            throw new IllegalStateException("activity has no successors");
        }
        return this.next;
    }

    @Override
    public TestCaseActivityScope getParent() {
        if (!this.hasParent()) {
            throw new IllegalStateException("activity has no parent");
        }
        return this.parent;
    }

    @Override
    public TestCaseActivity getPrevious() {
        if (!this.hasPrevious()) {
            throw new IllegalStateException("activity has no predecessor");
        }
        return this.prev;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public TestCaseActivityType getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.flowNode.getElementType().getTypeName();
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public boolean hasMultiInstanceParent() {
        return this.hasParent() && this.parent.isMultiInstance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean hasPrevious() {
        return this.prev != null;
    }

    @Override
    public boolean hasPrevious(TestCaseActivityType type) {
        return this.hasPrevious() && this.getPrevious().getType() == type;
    }

    @Override
    public boolean isAsyncAfter() {
        return this.type != TestCaseActivityType.EVENT_BASED_GATEWAY && this.flowNode.isCamundaAsyncAfter();
    }

    @Override
    public boolean isAsyncBefore() {
        return this.flowNode.isCamundaAsyncBefore();
    }

    @Override
    public boolean isAttachedTo(TestCaseActivity activity) {
        return activity.getId().equals(this.attachedTo);
    }

    @Override
    public boolean isMultiInstance() {
        return this.multiInstanceLoopCharacteristics != null;
    }

    @Override
    public boolean isMultiInstanceParallel() {
        return !this.isMultiInstanceSequential();
    }

    @Override
    public boolean isMultiInstanceSequential() {
        if (!this.isMultiInstance()) {
            throw new IllegalStateException("activity is not a multi instance");
        }
        return this.multiInstanceLoopCharacteristics.isSequential();
    }

    @Override
    public boolean isProcessEnd() {
        return this.processEnd;
    }

    @Override
    public boolean isProcessStart() {
        return this.processStart;
    }
}

