/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.bpmndt.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.community.bpmndt.model.TestCase;
import org.camunda.community.bpmndt.model.TestCaseActivity;
import org.camunda.community.bpmndt.model.TestCaseActivityImpl;
import org.camunda.community.bpmndt.model.TestCaseActivityScope;
import org.camunda.community.bpmndt.model.TestCaseActivityScopeImpl;
import org.camunda.community.bpmndt.model.element.TestCaseElement;

class TestCaseImpl
implements TestCase {
    protected TestCaseElement element;
    protected Process process;
    private final LinkedList<TestCaseActivity> activities = new LinkedList();
    private final List<String> invalidFlowNodeIds = new LinkedList<String>();
    private final Map<String, TestCaseActivityScopeImpl> scopes = new LinkedHashMap<String, TestCaseActivityScopeImpl>();
    private TestCaseActivityImpl prev;

    TestCaseImpl() {
    }

    protected void addActivity(TestCaseActivityImpl next) {
        if (this.prev != null) {
            this.prev.next = next;
            next.prev = this.prev;
        }
        this.activities.add(next);
        this.prev = next;
    }

    protected void addActivityScope(TestCaseActivityScopeImpl scope) {
        this.scopes.put(scope.getId(), scope);
    }

    protected void addInvalidFlowNodeId(String flowNodeId) {
        this.invalidFlowNodeIds.add(flowNodeId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TestCase)) {
            return false;
        }
        TestCase testCase = (TestCase)obj;
        return testCase.getProcessId().equals(this.getProcessId()) && testCase.getName().equals(this.getName());
    }

    @Override
    public List<TestCaseActivity> getActivities() {
        return this.activities;
    }

    protected TestCaseActivityScopeImpl getActivityScope(String scopeId) {
        return this.scopes.get(scopeId);
    }

    @Override
    public List<TestCaseActivityScope> getActivityScopes() {
        return new ArrayList<TestCaseActivityScope>(this.scopes.values());
    }

    @Override
    public String getDescription() {
        return this.element.getDescription();
    }

    @Override
    public TestCaseActivity getEndActivity() {
        if (this.activities.isEmpty()) {
            throw new IllegalStateException("path is empty");
        }
        return this.activities.getLast();
    }

    @Override
    public List<String> getFlowNodeIds() {
        return this.element.getPath().getFlowNodeIds();
    }

    @Override
    public List<String> getInvalidFlowNodeIds() {
        return this.invalidFlowNodeIds;
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public String getProcessId() {
        return this.process.getId();
    }

    @Override
    public String getProcessName() {
        return this.process.getName();
    }

    @Override
    public TestCaseActivity getStartActivity() {
        if (this.activities.isEmpty()) {
            throw new IllegalStateException("path is empty");
        }
        return this.activities.getFirst();
    }

    public int hashCode() {
        return Objects.hash(this.getProcessId(), this.getName());
    }

    @Override
    public boolean hasEmptyPath() {
        return this.getFlowNodeIds().size() == 0;
    }

    @Override
    public boolean hasIncompletePath() {
        return this.getFlowNodeIds().size() == 1;
    }

    @Override
    public boolean hasInvalidPath() {
        return !this.invalidFlowNodeIds.isEmpty();
    }

    @Override
    public boolean isValid() {
        return !this.hasEmptyPath() && !this.hasIncompletePath() && !this.hasInvalidPath();
    }
}

