/*
 * Decompiled with CFR 0.152.
 */
package com.camunda.consulting.zeebe_ejb.cdi_adapter.juel;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.el.JuelExpression;
import org.camunda.bpm.engine.impl.el.JuelExpressionManager;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.javax.el.ELException;
import org.camunda.bpm.engine.impl.javax.el.MethodNotFoundException;
import org.camunda.bpm.engine.impl.javax.el.PropertyNotFoundException;
import org.camunda.bpm.engine.impl.javax.el.ValueExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginelessJuelExpression
extends JuelExpression {
    private static final Logger LOG = LoggerFactory.getLogger(EnginelessJuelExpression.class);

    public EnginelessJuelExpression(ValueExpression valueExpression, JuelExpressionManager expressionManager, String expressionText) {
        super(valueExpression, expressionManager, expressionText);
        LOG.info("EnginelessJuelExpression initated with {}, {}, {}", new Object[]{valueExpression, expressionManager, expressionText});
    }

    public Object getValue(VariableScope variableScope, BaseDelegateExecution contextExecution) {
        LOG.info("get Value with {}, {}", (Object)variableScope, (Object)contextExecution);
        variableScope.setVariable("execution", (Object)contextExecution);
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            Object object = this.valueExpression.getValue(elContext);
            return object;
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ProcessEngineException("Unknown property used in expression: " + this.expressionText + ". Cause: " + pnfe.getMessage(), (Throwable)pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ProcessEngineException("Unknown method used in expression: " + this.expressionText + ". Cause: " + mnfe.getMessage(), (Throwable)mnfe);
        }
        catch (ELException ele) {
            throw new ProcessEngineException("EL Error while evaluating expression: " + this.expressionText + ". Cause: " + ele.getMessage(), (Throwable)ele);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Error while evaluating expression: " + this.expressionText + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            variableScope.removeVariable("execution");
        }
    }
}

