/*
 * Decompiled with CFR 0.152.
 */
package com.camunda.consulting.zeebe_ejb.cdi_adapter.worker;

import com.camunda.consulting.zeebe_ejb.JobWorker;
import com.camunda.consulting.zeebe_ejb.cdi_adapter.execution.ZeebeJobDelegateExecution;
import com.camunda.consulting.zeebe_ejb.cdi_adapter.juel.JuelExpressionResolver;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.camunda.bpm.engine.cdi.CdiArtifactFactory;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@JobWorker(type="camunda-7-adapter", autoComplete=false)
public class CamundaPlatform7DelegationWorker
implements JobHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaPlatform7DelegationWorker.class);
    private final JuelExpressionResolver expressionResolver;
    private final CdiArtifactFactory artifactFactory;

    public CamundaPlatform7DelegationWorker() {
        LOG.info("create delegation worker blank");
        this.expressionResolver = null;
        this.artifactFactory = null;
    }

    @Inject
    public CamundaPlatform7DelegationWorker(JuelExpressionResolver expressionResolver, CdiArtifactFactory artifactFactory) {
        LOG.info("Create delegation worker with parameters {}, {}", (Object)expressionResolver, (Object)artifactFactory);
        this.expressionResolver = expressionResolver;
        this.artifactFactory = artifactFactory;
    }

    public void handle(JobClient client, ActivatedJob job) throws Exception {
        String delegateClass = (String)job.getCustomHeaders().get("class");
        String delegateExpression = (String)job.getCustomHeaders().get("delegateExpression");
        String expression = (String)job.getCustomHeaders().get("expression");
        String resultVariable = (String)job.getCustomHeaders().get("resultVariable");
        HashMap<String, Object> resultPayload = null;
        DelegateExecution execution = this.wrapDelegateExecution(job);
        DelegateExecution variableScope = this.wrapDelegateExecution(job);
        try {
            JavaDelegate javaDelegate;
            if (delegateClass != null) {
                javaDelegate = this.loadJavaDelegate(delegateClass);
                javaDelegate.execute(execution);
                resultPayload = execution.getVariables();
            } else if (delegateExpression != null) {
                javaDelegate = (JavaDelegate)this.expressionResolver.evaluate(delegateExpression, (VariableScope)variableScope, execution);
                javaDelegate.execute(execution);
                resultPayload = execution.getVariables();
            } else if (expression != null) {
                Object result = this.expressionResolver.evaluate(expression, (VariableScope)variableScope, execution);
                if (resultVariable != null) {
                    resultPayload = new HashMap<String, Object>();
                    resultPayload.put(resultVariable, result);
                }
            } else {
                throw new RuntimeException("Either 'class' or 'delegateExpression' or 'expression' must be specified in task headers for job :" + job);
            }
            CompleteJobCommandStep1 completeCommand = client.newCompleteCommand(job.getKey());
            if (resultPayload != null) {
                completeCommand.variables(resultPayload);
            }
            completeCommand.send().join();
        }
        catch (BpmnError e) {
            throw new UnsupportedOperationException("BPMN Error not yet supported: " + e.getMessage());
        }
    }

    private DelegateExecution wrapDelegateExecution(ActivatedJob job) {
        return new ZeebeJobDelegateExecution(job);
    }

    private JavaDelegate loadJavaDelegate(String delegateName) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = contextClassLoader.loadClass(delegateName);
            return (JavaDelegate)this.artifactFactory.getArtifact(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load delegation class '" + delegateName + "': " + e.getMessage(), e);
        }
    }
}

