/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.protocol.impl.record.CopiedRecord;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.EngineFactory;
import org.camunda.community.eze.GrpcResponseWriter;
import org.camunda.community.eze.InMemoryLogStorage;
import org.camunda.community.eze.SimpleGateway;
import org.camunda.community.eze.SinglePartitionDeploymentDistributor;
import org.camunda.community.eze.SinglePartitionDeploymentResponder;
import org.camunda.community.eze.SubscriptionCommandSenderFactory;
import org.camunda.community.eze.ZeebeEngine;
import org.camunda.community.eze.ZeebeEngineImpl;
import org.camunda.community.eze.db.EzeZeebeDbFactory;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J6\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/camunda/community/eze/EngineFactory;", "", "()V", "subscriptionCommandSenderFactory", "Lorg/camunda/community/eze/SubscriptionCommandSenderFactory;", "create", "Lorg/camunda/community/eze/ZeebeEngine;", "createActorClock", "Lio/camunda/zeebe/util/sched/clock/ControlledActorClock;", "createActorScheduler", "Lio/camunda/zeebe/util/sched/ActorScheduler;", "clock", "Lio/camunda/zeebe/util/sched/clock/ActorClock;", "createDatabase", "Lio/camunda/zeebe/db/ZeebeDb;", "Lio/camunda/zeebe/engine/state/ZbColumnFamilies;", "createLogStorage", "Lio/camunda/zeebe/logstreams/storage/LogStorage;", "createLogStream", "Lio/camunda/zeebe/logstreams/log/LogStream;", "partitionId", "", "logStorage", "scheduler", "Lio/camunda/zeebe/util/sched/ActorSchedulingService;", "createRecordStream", "", "Lio/camunda/zeebe/protocol/record/Record;", "reader", "Lio/camunda/zeebe/logstreams/log/LogStreamReader;", "createStreamProcessor", "Lio/camunda/zeebe/engine/processing/streamprocessor/StreamProcessor;", "partitionCount", "logStream", "database", "grpcResponseWriter", "Lorg/camunda/community/eze/GrpcResponseWriter;", "eze"})
public final class EngineFactory {
    @NotNull
    public static final EngineFactory INSTANCE = new EngineFactory();
    @NotNull
    private static final SubscriptionCommandSenderFactory subscriptionCommandSenderFactory = new SubscriptionCommandSenderFactory((Function1<? super Integer, ? extends LogStreamRecordWriter>)((Function1)subscriptionCommandSenderFactory.1.INSTANCE));

    private EngineFactory() {
    }

    @NotNull
    public final ZeebeEngine create() {
        ControlledActorClock clock = this.createActorClock();
        ActorScheduler scheduler = this.createActorScheduler((ActorClock)clock);
        LogStorage logStorage = this.createLogStorage();
        LogStream logStream = this.createLogStream(1, logStorage, (ActorSchedulingService)scheduler);
        LogStreamRecordWriter streamWriter = (LogStreamRecordWriter)logStream.newLogStreamRecordWriter().join();
        Intrinsics.checkNotNullExpressionValue((Object)streamWriter, (String)"streamWriter");
        SimpleGateway simpleGateway = new SimpleGateway(streamWriter);
        Server server = ServerBuilder.forPort((int)26500).addService((BindableService)simpleGateway).build();
        ZeebeDb<ZbColumnFamilies> db = this.createDatabase();
        GrpcResponseWriter grpcResponseWriter2 = new GrpcResponseWriter((Function2<? super Long, ? super GeneratedMessageV3, Unit>)((Function2)new Function2<Long, GeneratedMessageV3, Unit>(simpleGateway){

            public final void invoke(long p0, @NotNull GeneratedMessageV3 p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((SimpleGateway)this.receiver).responseCallback(p0, p1);
            }
        }), (Function2<? super Long, ? super Status, Unit>)((Function2)new Function2<Long, Status, Unit>(simpleGateway){

            public final void invoke(long p0, @NotNull Status p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((SimpleGateway)this.receiver).errorCallback(p0, p1);
            }
        }));
        StreamProcessor streamProcessor = this.createStreamProcessor(1, logStream, db, (ActorSchedulingService)scheduler, grpcResponseWriter2);
        LogStreamReader reader = (LogStreamReader)logStream.newLogStreamReader().join();
        return new ZeebeEngineImpl(() -> EngineFactory.create$lambda-0(server, streamProcessor), () -> EngineFactory.create$lambda-1(server, simpleGateway, streamProcessor, db, logStream, scheduler), (Function0)new Function0<Iterable<? extends Record<?>>>(reader){
            final /* synthetic */ LogStreamReader $reader;
            {
                this.$reader = $reader;
                super(0);
            }

            @NotNull
            public final Iterable<Record<?>> invoke() {
                LogStreamReader logStreamReader = this.$reader;
                Intrinsics.checkNotNullExpressionValue((Object)logStreamReader, (String)"reader");
                return EngineFactory.access$createRecordStream(EngineFactory.INSTANCE, logStreamReader);
            }
        }, clock);
    }

    private final StreamProcessor createStreamProcessor(int partitionCount, LogStream logStream, ZeebeDb<ZbColumnFamilies> database, ActorSchedulingService scheduler, GrpcResponseWriter grpcResponseWriter2) {
        StreamProcessor streamProcessor = StreamProcessor.builder().logStream(logStream).zeebeDb(database).eventApplierFactory(EngineFactory::createStreamProcessor$lambda-2).commandResponseWriter((CommandResponseWriter)grpcResponseWriter2).streamProcessorFactory(arg_0 -> EngineFactory.createStreamProcessor$lambda-4(partitionCount, arg_0)).actorSchedulingService(scheduler).build();
        Intrinsics.checkNotNullExpressionValue((Object)streamProcessor, (String)"builder()\n            .logStream(logStream)\n            .zeebeDb(database)\n            .eventApplierFactory { EventAppliers(it) }\n            .commandResponseWriter(grpcResponseWriter)\n            .streamProcessorFactory { context ->\n                EngineProcessors.createEngineProcessors(\n                    context,\n                    partitionCount,\n                    subscriptionCommandSenderFactory.ofPartition(partitionId = 1),\n                    SinglePartitionDeploymentDistributor(),\n                    SinglePartitionDeploymentResponder(),\n                    { jobType ->\n                        // new job is available\n                    }\n                )\n            }\n            .actorSchedulingService(scheduler)\n            .build()");
        return streamProcessor;
    }

    private final ZeebeDb<ZbColumnFamilies> createDatabase() {
        ZeebeDbFactory zeebeDbFactory = EzeZeebeDbFactory.getDefaultFactory();
        ZeebeDb zeebeDb = zeebeDbFactory.createDb(Files.createTempDirectory("zeebeDb", new FileAttribute[0]).toFile());
        Intrinsics.checkNotNullExpressionValue((Object)zeebeDb, (String)"zeebeDbFactory.createDb(Files.createTempDirectory(\"zeebeDb\").toFile())");
        return zeebeDb;
    }

    private final LogStream createLogStream(int partitionId, LogStorage logStorage, ActorSchedulingService scheduler) {
        LogStreamBuilder builder = LogStream.builder().withPartitionId(partitionId).withLogStorage(logStorage).withActorSchedulingService(scheduler);
        CompletableFuture theFuture = new CompletableFuture();
        scheduler.submitActor(Actor.wrap(arg_0 -> EngineFactory.createLogStream$lambda-6(builder, theFuture, arg_0)));
        Object t = theFuture.join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"theFuture.join()");
        return (LogStream)t;
    }

    private final LogStorage createLogStorage() {
        return new InMemoryLogStorage();
    }

    private final ActorScheduler createActorScheduler(ActorClock clock) {
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setActorClock(clock).build();
        scheduler.start();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"scheduler");
        return scheduler;
    }

    private final ControlledActorClock createActorClock() {
        return new ControlledActorClock();
    }

    private final Iterable<Record<?>> createRecordStream(LogStreamReader reader) {
        reader.seekToFirstEvent();
        boolean bl = false;
        List records = new ArrayList();
        Iterator $this$forEach$iv = (Iterator)reader;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            LoggedEvent it = (LoggedEvent)element$iv;
            boolean bl3 = false;
            RecordMetadata metadata = new RecordMetadata();
            it.readMetadata((BufferReader)metadata);
            Object v = TypedEventRegistry.EVENT_REGISTRY.get(metadata.getValueType());
            Intrinsics.checkNotNull(v);
            UnifiedRecordValue value = (UnifiedRecordValue)((Class)v).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            it.readValue((BufferReader)value);
            CopiedRecord record = new CopiedRecord(value, metadata, it.getKey(), 1, it.getPosition(), it.getSourceEventPosition(), it.getTimestamp());
            records.add(record);
        }
        return records;
    }

    private static final void create$lambda-0(Server $server, StreamProcessor $streamProcessor) {
        Intrinsics.checkNotNullParameter((Object)$streamProcessor, (String)"$streamProcessor");
        $server.start();
        $streamProcessor.openAsync(false).join();
    }

    private static final void create$lambda-1(Server $server, SimpleGateway $simpleGateway, StreamProcessor $streamProcessor, ZeebeDb $db, LogStream $logStream, ActorScheduler $scheduler) {
        Intrinsics.checkNotNullParameter((Object)$simpleGateway, (String)"$simpleGateway");
        Intrinsics.checkNotNullParameter((Object)$streamProcessor, (String)"$streamProcessor");
        Intrinsics.checkNotNullParameter((Object)$db, (String)"$db");
        Intrinsics.checkNotNullParameter((Object)$logStream, (String)"$logStream");
        Intrinsics.checkNotNullParameter((Object)$scheduler, (String)"$scheduler");
        $server.shutdownNow();
        $server.awaitTermination();
        $simpleGateway.close();
        $streamProcessor.close();
        $db.close();
        $logStream.close();
        $scheduler.stop();
    }

    private static final EventApplier createStreamProcessor$lambda-2(MutableZeebeState it) {
        return (EventApplier)new EventAppliers(it);
    }

    private static final void createStreamProcessor$lambda-4$lambda-3(String jobType) {
    }

    private static final TypedRecordProcessors createStreamProcessor$lambda-4(int $partitionCount, ProcessingContext context) {
        return EngineProcessors.createEngineProcessors((ProcessingContext)context, (int)$partitionCount, (SubscriptionCommandSender)subscriptionCommandSenderFactory.ofPartition(1), (DeploymentDistributor)new SinglePartitionDeploymentDistributor(), (DeploymentResponder)new SinglePartitionDeploymentResponder(), EngineFactory::createStreamProcessor$lambda-4$lambda-3);
    }

    private static final void createLogStream$lambda-6$lambda-5(CompletableFuture $theFuture, LogStream logStream, Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)$theFuture, (String)"$theFuture");
        $theFuture.complete(logStream);
    }

    private static final void createLogStream$lambda-6(LogStreamBuilder $builder, CompletableFuture $theFuture, ActorControl it) {
        Intrinsics.checkNotNullParameter((Object)$theFuture, (String)"$theFuture");
        $builder.buildAsync().onComplete((arg_0, arg_1) -> EngineFactory.createLogStream$lambda-6$lambda-5($theFuture, arg_0, arg_1));
    }

    public static final /* synthetic */ Iterable access$createRecordStream(EngineFactory $this, LogStreamReader reader) {
        return $this.createRecordStream(reader);
    }
}

