/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.protocol.impl.record.CopiedRecord;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.EngineFactory;
import org.camunda.community.eze.ExporterRunner;
import org.camunda.community.eze.GrpcResponseWriter;
import org.camunda.community.eze.GrpcToLogStreamGateway;
import org.camunda.community.eze.InMemoryLogStorage;
import org.camunda.community.eze.SinglePartitionDeploymentDistributor;
import org.camunda.community.eze.SinglePartitionDeploymentResponder;
import org.camunda.community.eze.SubscriptionCommandSenderFactory;
import org.camunda.community.eze.ZeebeEngine;
import org.camunda.community.eze.ZeebeEngineImpl;
import org.camunda.community.eze.db.EzeZeebeDbFactory;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u000f2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0002J6\u0010'\u001a\u00020(2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0004j\u0002`\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/camunda/community/eze/EngineFactory;", "", "()V", "partitionCount", "", "partitionId", "Lorg/camunda/community/eze/PartitionId;", "streamWritersByPartition", "", "Lio/camunda/zeebe/logstreams/log/LogStreamRecordWriter;", "subscriptionCommandSenderFactory", "Lorg/camunda/community/eze/SubscriptionCommandSenderFactory;", "create", "Lorg/camunda/community/eze/ZeebeEngine;", "exporters", "", "Lio/camunda/zeebe/exporter/api/Exporter;", "createActorClock", "Lio/camunda/zeebe/util/sched/clock/ControlledActorClock;", "createActorScheduler", "Lio/camunda/zeebe/util/sched/ActorScheduler;", "clock", "Lio/camunda/zeebe/util/sched/clock/ActorClock;", "createDatabase", "Lio/camunda/zeebe/db/ZeebeDb;", "Lio/camunda/zeebe/engine/state/ZbColumnFamilies;", "createLogStorage", "Lio/camunda/zeebe/logstreams/storage/LogStorage;", "createLogStream", "Lio/camunda/zeebe/logstreams/log/LogStream;", "logStorage", "scheduler", "Lio/camunda/zeebe/util/sched/ActorSchedulingService;", "createRecordStream", "Lio/camunda/zeebe/protocol/record/Record;", "reader", "Lio/camunda/zeebe/logstreams/log/LogStreamReader;", "position", "", "createStreamProcessor", "Lio/camunda/zeebe/engine/processing/streamprocessor/StreamProcessor;", "logStream", "database", "grpcResponseWriter", "Lorg/camunda/community/eze/GrpcResponseWriter;", "eze"})
public final class EngineFactory {
    @NotNull
    public static final EngineFactory INSTANCE = new EngineFactory();
    private static final int partitionId = 1;
    private static final int partitionCount = 1;
    @NotNull
    private static final Map<Integer, LogStreamRecordWriter> streamWritersByPartition;
    @NotNull
    private static final SubscriptionCommandSenderFactory subscriptionCommandSenderFactory;

    private EngineFactory() {
    }

    @NotNull
    public final ZeebeEngine create(@NotNull Iterable<? extends Exporter> exporters) {
        Intrinsics.checkNotNullParameter(exporters, (String)"exporters");
        ControlledActorClock clock = this.createActorClock();
        ActorScheduler scheduler = this.createActorScheduler((ActorClock)clock);
        LogStorage logStorage = this.createLogStorage();
        LogStream logStream = this.createLogStream(partitionId, logStorage, (ActorSchedulingService)scheduler);
        LogStreamRecordWriter streamWriter = (LogStreamRecordWriter)logStream.newLogStreamRecordWriter().join();
        Map<Integer, LogStreamRecordWriter> map = streamWritersByPartition;
        Integer n = partitionId;
        Intrinsics.checkNotNullExpressionValue((Object)streamWriter, (String)"streamWriter");
        LogStreamRecordWriter logStreamRecordWriter = streamWriter;
        boolean bl = false;
        map.put(n, logStreamRecordWriter);
        GrpcToLogStreamGateway gateway = new GrpcToLogStreamGateway(streamWriter);
        Server grpcServer = ServerBuilder.forPort((int)26500).addService((BindableService)gateway).build();
        ZeebeDb<ZbColumnFamilies> zeebeDb = this.createDatabase();
        GrpcResponseWriter grpcResponseWriter2 = new GrpcResponseWriter((Function2<? super Long, ? super GeneratedMessageV3, Unit>)((Function2)new Function2<Long, GeneratedMessageV3, Unit>(gateway){

            public final void invoke(long p0, @NotNull GeneratedMessageV3 p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((GrpcToLogStreamGateway)this.receiver).responseCallback(p0, p1);
            }
        }), (Function2<? super Long, ? super Status, Unit>)((Function2)new Function2<Long, Status, Unit>(gateway){

            public final void invoke(long p0, @NotNull Status p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((GrpcToLogStreamGateway)this.receiver).errorCallback(p0, p1);
            }
        }));
        StreamProcessor streamProcessor = this.createStreamProcessor(partitionCount, logStream, zeebeDb, (ActorSchedulingService)scheduler, grpcResponseWriter2);
        LogStreamReader reader = (LogStreamReader)logStream.newLogStreamReader().join();
        ExporterRunner exporterRunner2 = new ExporterRunner(exporters, (Function1)new Function1<Long, Iterable<? extends Record<?>>>(reader){
            final /* synthetic */ LogStreamReader $reader;
            {
                this.$reader = $reader;
                super(1);
            }

            @NotNull
            public final Iterable<Record<?>> invoke(long position) {
                LogStreamReader logStreamReader = this.$reader;
                Intrinsics.checkNotNullExpressionValue((Object)logStreamReader, (String)"reader");
                return EngineFactory.access$createRecordStream(EngineFactory.INSTANCE, logStreamReader, position);
            }
        });
        logStream.registerRecordAvailableListener(exporterRunner2::onRecordsAvailable);
        return new ZeebeEngineImpl(() -> EngineFactory.create$lambda-0(grpcServer, streamProcessor, exporterRunner2), () -> EngineFactory.create$lambda-1(grpcServer, gateway, exporterRunner2, streamProcessor, zeebeDb, logStream, scheduler), (Function0)new Function0<Iterable<? extends Record<?>>>(reader){
            final /* synthetic */ LogStreamReader $reader;
            {
                this.$reader = $reader;
                super(0);
            }

            @NotNull
            public final Iterable<Record<?>> invoke() {
                LogStreamReader logStreamReader = this.$reader;
                Intrinsics.checkNotNullExpressionValue((Object)logStreamReader, (String)"reader");
                return EngineFactory.createRecordStream$default(EngineFactory.INSTANCE, logStreamReader, 0L, 2, null);
            }
        }, clock);
    }

    public static /* synthetic */ ZeebeEngine create$default(EngineFactory engineFactory, Iterable iterable, int n, Object object) {
        if ((n & 1) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return engineFactory.create(iterable);
    }

    private final StreamProcessor createStreamProcessor(int partitionCount, LogStream logStream, ZeebeDb<ZbColumnFamilies> database, ActorSchedulingService scheduler, GrpcResponseWriter grpcResponseWriter2) {
        StreamProcessor streamProcessor = StreamProcessor.builder().logStream(logStream).zeebeDb(database).eventApplierFactory(EngineFactory::createStreamProcessor$lambda-2).commandResponseWriter((CommandResponseWriter)grpcResponseWriter2).streamProcessorFactory(arg_0 -> EngineFactory.createStreamProcessor$lambda-4(partitionCount, arg_0)).actorSchedulingService(scheduler).build();
        Intrinsics.checkNotNullExpressionValue((Object)streamProcessor, (String)"builder()\n            .logStream(logStream)\n            .zeebeDb(database)\n            .eventApplierFactory { EventAppliers(it) }\n            .commandResponseWriter(grpcResponseWriter)\n            .streamProcessorFactory { context ->\n                EngineProcessors.createEngineProcessors(\n                    context,\n                    partitionCount,\n                    subscriptionCommandSenderFactory.ofPartition(partitionId = partitionId),\n                    SinglePartitionDeploymentDistributor(),\n                    SinglePartitionDeploymentResponder(),\n                    { jobType ->\n                        // new job is available\n                    }\n                )\n            }\n            .actorSchedulingService(scheduler)\n            .build()");
        return streamProcessor;
    }

    private final ZeebeDb<ZbColumnFamilies> createDatabase() {
        ZeebeDbFactory zeebeDbFactory = EzeZeebeDbFactory.getDefaultFactory();
        ZeebeDb zeebeDb = zeebeDbFactory.createDb(Files.createTempDirectory("zeebeDb", new FileAttribute[0]).toFile());
        Intrinsics.checkNotNullExpressionValue((Object)zeebeDb, (String)"zeebeDbFactory.createDb(Files.createTempDirectory(\"zeebeDb\").toFile())");
        return zeebeDb;
    }

    private final LogStream createLogStream(int partitionId, LogStorage logStorage, ActorSchedulingService scheduler) {
        LogStreamBuilder builder = LogStream.builder().withPartitionId(partitionId).withLogStorage(logStorage).withActorSchedulingService(scheduler);
        CompletableFuture theFuture = new CompletableFuture();
        scheduler.submitActor(Actor.wrap(arg_0 -> EngineFactory.createLogStream$lambda-6(builder, theFuture, arg_0)));
        Object t = theFuture.join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"theFuture.join()");
        return (LogStream)t;
    }

    private final LogStorage createLogStorage() {
        return new InMemoryLogStorage();
    }

    private final ActorScheduler createActorScheduler(ActorClock clock) {
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setActorClock(clock).build();
        scheduler.start();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"scheduler");
        return scheduler;
    }

    private final ControlledActorClock createActorClock() {
        return new ControlledActorClock();
    }

    private final Iterable<Record<?>> createRecordStream(LogStreamReader reader, long position) {
        Boolean bl;
        Long l;
        Long l2 = position;
        boolean bl2 = false;
        boolean bl3 = false;
        long it = ((Number)l2).longValue();
        boolean bl4 = false;
        Long l3 = l = it > 0L ? l2 : null;
        if (l == null) {
            bl = null;
        } else {
            l2 = l;
            bl2 = false;
            bl3 = false;
            it = ((Number)l2).longValue();
            boolean bl5 = false;
            bl = reader.seekToNextEvent(it);
        }
        Boolean bl6 = bl;
        if (bl6 == null) {
            reader.seekToFirstEvent();
        }
        boolean bl7 = false;
        List records = new ArrayList();
        Iterator $this$forEach$iv = (Iterator)reader;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        bl3 = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            LoggedEvent it2 = (LoggedEvent)element$iv;
            boolean bl8 = false;
            RecordMetadata metadata = new RecordMetadata();
            it2.readMetadata((BufferReader)metadata);
            Object v = TypedEventRegistry.EVENT_REGISTRY.get(metadata.getValueType());
            Intrinsics.checkNotNull(v);
            UnifiedRecordValue value = (UnifiedRecordValue)((Class)v).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            it2.readValue((BufferReader)value);
            CopiedRecord record = new CopiedRecord(value, metadata, it2.getKey(), partitionId, it2.getPosition(), it2.getSourceEventPosition(), it2.getTimestamp());
            records.add(record);
        }
        return records;
    }

    static /* synthetic */ Iterable createRecordStream$default(EngineFactory engineFactory, LogStreamReader logStreamReader, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        return engineFactory.createRecordStream(logStreamReader, l);
    }

    private static final void create$lambda-0(Server $grpcServer, StreamProcessor $streamProcessor, ExporterRunner $exporterRunner) {
        Intrinsics.checkNotNullParameter((Object)$streamProcessor, (String)"$streamProcessor");
        Intrinsics.checkNotNullParameter((Object)$exporterRunner, (String)"$exporterRunner");
        $grpcServer.start();
        $streamProcessor.openAsync(false).join();
        $exporterRunner.open();
    }

    private static final void create$lambda-1(Server $grpcServer, GrpcToLogStreamGateway $gateway, ExporterRunner $exporterRunner, StreamProcessor $streamProcessor, ZeebeDb $zeebeDb, LogStream $logStream, ActorScheduler $scheduler) {
        Intrinsics.checkNotNullParameter((Object)$gateway, (String)"$gateway");
        Intrinsics.checkNotNullParameter((Object)$exporterRunner, (String)"$exporterRunner");
        Intrinsics.checkNotNullParameter((Object)$streamProcessor, (String)"$streamProcessor");
        Intrinsics.checkNotNullParameter((Object)$zeebeDb, (String)"$zeebeDb");
        Intrinsics.checkNotNullParameter((Object)$logStream, (String)"$logStream");
        Intrinsics.checkNotNullParameter((Object)$scheduler, (String)"$scheduler");
        $grpcServer.shutdownNow();
        $grpcServer.awaitTermination();
        $gateway.close();
        $exporterRunner.close();
        $streamProcessor.close();
        $zeebeDb.close();
        $logStream.close();
        $scheduler.stop();
    }

    private static final EventApplier createStreamProcessor$lambda-2(MutableZeebeState it) {
        return (EventApplier)new EventAppliers(it);
    }

    private static final void createStreamProcessor$lambda-4$lambda-3(String jobType) {
    }

    private static final TypedRecordProcessors createStreamProcessor$lambda-4(int $partitionCount, ProcessingContext context) {
        return EngineProcessors.createEngineProcessors((ProcessingContext)context, (int)$partitionCount, (SubscriptionCommandSender)subscriptionCommandSenderFactory.ofPartition(partitionId), (DeploymentDistributor)new SinglePartitionDeploymentDistributor(), (DeploymentResponder)new SinglePartitionDeploymentResponder(), EngineFactory::createStreamProcessor$lambda-4$lambda-3);
    }

    private static final void createLogStream$lambda-6$lambda-5(CompletableFuture $theFuture, LogStream logStream, Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)$theFuture, (String)"$theFuture");
        if (failure != null) {
            $theFuture.completeExceptionally(failure);
        } else {
            $theFuture.complete(logStream);
        }
    }

    private static final void createLogStream$lambda-6(LogStreamBuilder $builder, CompletableFuture $theFuture, ActorControl it) {
        Intrinsics.checkNotNullParameter((Object)$theFuture, (String)"$theFuture");
        $builder.buildAsync().onComplete((arg_0, arg_1) -> EngineFactory.createLogStream$lambda-6$lambda-5($theFuture, arg_0, arg_1));
    }

    public static final /* synthetic */ Iterable access$createRecordStream(EngineFactory $this, LogStreamReader reader, long position) {
        return $this.createRecordStream(reader, position);
    }

    public static final /* synthetic */ Map access$getStreamWritersByPartition$p() {
        return streamWritersByPartition;
    }

    static {
        boolean bl = false;
        streamWritersByPartition = new LinkedHashMap();
        subscriptionCommandSenderFactory = new SubscriptionCommandSenderFactory((Function1<? super Integer, ? extends LogStreamRecordWriter>)((Function1)subscriptionCommandSenderFactory.1.INSTANCE));
    }
}

