/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.db;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.ObjIntConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0&J\u0010\u0010'\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\fJ\u0010\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\fJ\u000e\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010+\u001a\u00020\"2\u0006\u0010)\u001a\u00020,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u000e\u0010 \u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/camunda/community/eze/db/ColumnFamilyContext;", "", "columnFamilyPrefix", "", "(J)V", "isKeyViewEmpty", "", "()Z", "isValueViewEmpty", "keyBuffer", "Lorg/agrona/ExpandableArrayBuffer;", "keyBufferArray", "", "getKeyBufferArray", "()[B", "<set-?>", "", "keyLength", "getKeyLength", "()I", "keyView", "Lorg/agrona/DirectBuffer;", "getKeyView", "()Lorg/agrona/DirectBuffer;", "keyViewBuffer", "prefixKeyBuffers", "Ljava/util/Queue;", "valueBuffer", "valueBufferArray", "getValueBufferArray", "valueView", "getValueView", "valueViewBuffer", "withPrefixKey", "", "key", "Lio/camunda/zeebe/db/DbKey;", "prefixKeyConsumer", "Ljava/util/function/ObjIntConsumer;", "wrapKeyView", "wrapValueView", "value", "writeKey", "writeValue", "Lio/camunda/zeebe/db/DbValue;", "Companion", "eze"})
public final class ColumnFamilyContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long columnFamilyPrefix;
    @NotNull
    private final ExpandableArrayBuffer keyBuffer;
    @NotNull
    private final ExpandableArrayBuffer valueBuffer;
    @NotNull
    private final DirectBuffer keyViewBuffer;
    @NotNull
    private final DirectBuffer valueViewBuffer;
    @NotNull
    private final Queue<ExpandableArrayBuffer> prefixKeyBuffers;
    private int keyLength;
    @NotNull
    private static final byte[] ZERO_SIZE_ARRAY = new byte[0];

    public ColumnFamilyContext(long columnFamilyPrefix) {
        this.columnFamilyPrefix = columnFamilyPrefix;
        this.keyBuffer = new ExpandableArrayBuffer();
        this.valueBuffer = new ExpandableArrayBuffer();
        this.keyViewBuffer = (DirectBuffer)new UnsafeBuffer(0L, 0);
        this.valueViewBuffer = (DirectBuffer)new UnsafeBuffer(0L, 0);
        this.prefixKeyBuffers = new ArrayDeque();
        this.prefixKeyBuffers.add(new ExpandableArrayBuffer());
        this.prefixKeyBuffers.add(new ExpandableArrayBuffer());
    }

    public final int getKeyLength() {
        return this.keyLength;
    }

    public final void writeKey(@NotNull DbKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.keyLength = 0;
        this.keyBuffer.putLong(0, this.columnFamilyPrefix, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        ColumnFamilyContext columnFamilyContext = this;
        columnFamilyContext.keyLength += 8;
        key.write((MutableDirectBuffer)this.keyBuffer, 8);
        columnFamilyContext = this;
        columnFamilyContext.keyLength += key.getLength();
    }

    @NotNull
    public final byte[] getKeyBufferArray() {
        byte[] byArray = this.keyBuffer.byteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyBuffer.byteArray()");
        return byArray;
    }

    public final void writeValue(@NotNull DbValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.write((MutableDirectBuffer)this.valueBuffer, 0);
    }

    @NotNull
    public final byte[] getValueBufferArray() {
        byte[] byArray = this.valueBuffer.byteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"valueBuffer.byteArray()");
        return byArray;
    }

    public final void wrapKeyView(@Nullable byte[] key) {
        if (key != null) {
            this.keyViewBuffer.wrap(key, 8, key.length - 8);
        } else {
            this.keyViewBuffer.wrap(ZERO_SIZE_ARRAY);
        }
    }

    @Nullable
    public final DirectBuffer getKeyView() {
        return this.isKeyViewEmpty() ? null : this.keyViewBuffer;
    }

    public final boolean isKeyViewEmpty() {
        return this.keyViewBuffer.capacity() == ZERO_SIZE_ARRAY.length;
    }

    public final void wrapValueView(@Nullable byte[] value) {
        if (value != null) {
            this.valueViewBuffer.wrap(value);
        } else {
            this.valueViewBuffer.wrap(ZERO_SIZE_ARRAY);
        }
    }

    @Nullable
    public final DirectBuffer getValueView() {
        return this.isValueViewEmpty() ? null : this.valueViewBuffer;
    }

    public final boolean isValueViewEmpty() {
        return this.valueViewBuffer.capacity() == ZERO_SIZE_ARRAY.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withPrefixKey(@NotNull DbKey key, @NotNull ObjIntConsumer<byte[]> prefixKeyConsumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(prefixKeyConsumer, (String)"prefixKeyConsumer");
        ExpandableArrayBuffer expandableArrayBuffer = this.prefixKeyBuffers.peek();
        boolean bl = false;
        boolean bl2 = false;
        if (expandableArrayBuffer == null) {
            boolean bl3 = false;
            String string = "Currently nested prefix iterations are not supported! This will cause unexpected behavior.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ExpandableArrayBuffer prefixKeyBuffer = this.prefixKeyBuffers.remove();
        try {
            ExpandableArrayBuffer expandableArrayBuffer2 = prefixKeyBuffer;
            Intrinsics.checkNotNull((Object)expandableArrayBuffer2);
            expandableArrayBuffer2.putLong(0, this.columnFamilyPrefix, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
            key.write((MutableDirectBuffer)prefixKeyBuffer, 8);
            int prefixLength = 8 + key.getLength();
            prefixKeyConsumer.accept(prefixKeyBuffer.byteArray(), prefixLength);
        }
        finally {
            this.prefixKeyBuffers.add(prefixKeyBuffer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/camunda/community/eze/db/ColumnFamilyContext$Companion;", "", "()V", "ZERO_SIZE_ARRAY", "", "eze"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

