/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.db;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.KeyValuePairVisitor;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDbTransaction;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.agrona.DirectBuffer;
import org.camunda.community.eze.db.Bytes;
import org.camunda.community.eze.db.ColumnFamilyContext;
import org.camunda.community.eze.db.DbNullKey;
import org.camunda.community.eze.db.EzeDbIterator;
import org.camunda.community.eze.db.EzeDbTransaction;
import org.camunda.community.eze.db.TransactionConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\b\u000b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007B9\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00028\u0001\u0012\u0006\u0010\u000f\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0002J\u0015\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010)J\"\u0010*\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020,J\u001c\u0010*\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00020-J\u001c\u0010*\u001a\u00020!2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020,H\u0016J\u0016\u0010*\u001a\u00020!2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00020-H\u0016J\u0018\u0010.\u001a\u0004\u0018\u00018\u00022\u0006\u0010\"\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010/J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u00102\u001a\u00020(H\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u00105\u001a\u00020!2\u0006\u0010\"\u001a\u00028\u00012\u0006\u00106\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u00107J]\u00108\u001a\u00020(\"\n\b\u0003\u0010\u0003*\u0004\u0018\u00010\u0004\"\n\b\u0004\u0010\u0005*\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u0002H\u00032\u0006\u0010\u000f\u001a\u0002H\u00052\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0<H\u0002\u00a2\u0006\u0002\u0010=J$\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020\u00042\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020:H\u0016J$\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020\u00042\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020,H\u0016JQ\u0010>\u001a\u00020!\"\n\b\u0003\u0010\u0003*\u0004\u0018\u00010\u0004\"\n\b\u0004\u0010\u0005*\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u0002H\u00032\u0006\u0010\u000f\u001a\u0002H\u00052\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050:H\u0002\u00a2\u0006\u0002\u0010AJQ\u0010>\u001a\u00020!\"\n\b\u0003\u0010\u0003*\u0004\u0018\u00010\u0004\"\n\b\u0004\u0010\u0005*\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u0002H\u00032\u0006\u0010\u000f\u001a\u0002H\u00052\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050,H\u0002\u00a2\u0006\u0002\u0010BJ,\u0010>\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u00042\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020:H\u0002J,\u0010>\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u00042\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020,H\u0002J[\u0010>\u001a\u00020!\"\n\b\u0003\u0010\u0003*\u0004\u0018\u00010\u0004\"\n\b\u0004\u0010\u0005*\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u0002H\u00032\u0006\u0010\u000f\u001a\u0002H\u00052\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050:H\u0002\u00a2\u0006\u0002\u0010DJ[\u0010>\u001a\u00020!\"\n\b\u0003\u0010\u0003*\u0004\u0018\u00010\u0004\"\n\b\u0004\u0010\u0005*\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u0002H\u00032\u0006\u0010\u000f\u001a\u0002H\u00052\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050,H\u0002\u00a2\u0006\u0002\u0010EJ\u001c\u0010F\u001a\u00020!2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020:H\u0016J$\u0010F\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020:H\u0002R\u0013\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000f\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006G"}, d2={"Lorg/camunda/community/eze/db/EzeDbColumnFamily;", "ColumnFamilyNames", "", "KeyType", "Lio/camunda/zeebe/db/DbKey;", "ValueType", "Lio/camunda/zeebe/db/DbValue;", "Lio/camunda/zeebe/db/ColumnFamily;", "database", "Ljava/util/TreeMap;", "Lorg/camunda/community/eze/db/Bytes;", "columnFamily", "context", "Lio/camunda/zeebe/db/TransactionContext;", "keyInstance", "valueInstance", "(Ljava/util/TreeMap;Ljava/lang/Enum;Lio/camunda/zeebe/db/TransactionContext;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;)V", "getColumnFamily", "()Ljava/lang/Enum;", "Ljava/lang/Enum;", "columnFamilyContext", "Lorg/camunda/community/eze/db/ColumnFamilyContext;", "getContext", "()Lio/camunda/zeebe/db/TransactionContext;", "getDatabase", "()Ljava/util/TreeMap;", "getKeyInstance", "()Lio/camunda/zeebe/db/DbKey;", "Lio/camunda/zeebe/db/DbKey;", "getValueInstance", "()Lio/camunda/zeebe/db/DbValue;", "Lio/camunda/zeebe/db/DbValue;", "delete", "", "key", "(Lio/camunda/zeebe/db/DbKey;)V", "ensureInOpenTransaction", "operation", "Lorg/camunda/community/eze/db/TransactionConsumer;", "exists", "", "(Lio/camunda/zeebe/db/DbKey;)Z", "forEach", "consumer", "Ljava/util/function/BiConsumer;", "Ljava/util/function/Consumer;", "get", "(Lio/camunda/zeebe/db/DbKey;)Lio/camunda/zeebe/db/DbValue;", "getValue", "Lorg/agrona/DirectBuffer;", "isEmpty", "newIterator", "Lorg/camunda/community/eze/db/EzeDbIterator;", "put", "value", "(Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;)V", "visit", "iteratorConsumer", "Lio/camunda/zeebe/db/KeyValuePairVisitor;", "entry", "", "(Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;Lio/camunda/zeebe/db/KeyValuePairVisitor;Ljava/util/Map$Entry;)Z", "whileEqualPrefix", "keyPrefix", "visitor", "(Lio/camunda/zeebe/db/TransactionContext;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;Lio/camunda/zeebe/db/KeyValuePairVisitor;)V", "(Lio/camunda/zeebe/db/TransactionContext;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;Ljava/util/function/BiConsumer;)V", "prefix", "(Lio/camunda/zeebe/db/TransactionContext;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;Lio/camunda/zeebe/db/KeyValuePairVisitor;)V", "(Lio/camunda/zeebe/db/TransactionContext;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;Ljava/util/function/BiConsumer;)V", "whileTrue", "eze"})
public final class EzeDbColumnFamily<ColumnFamilyNames extends Enum<ColumnFamilyNames>, KeyType extends DbKey, ValueType extends DbValue>
implements ColumnFamily<KeyType, ValueType> {
    @NotNull
    private final TreeMap<Bytes, Bytes> database;
    @NotNull
    private final ColumnFamilyNames columnFamily;
    @NotNull
    private final TransactionContext context;
    @NotNull
    private final KeyType keyInstance;
    @NotNull
    private final ValueType valueInstance;
    @NotNull
    private final ColumnFamilyContext columnFamilyContext;

    public EzeDbColumnFamily(@NotNull TreeMap<Bytes, Bytes> database, @NotNull ColumnFamilyNames columnFamily, @NotNull TransactionContext context, @NotNull KeyType keyInstance, @NotNull ValueType valueInstance) {
        Intrinsics.checkNotNullParameter(database, (String)"database");
        Intrinsics.checkNotNullParameter(columnFamily, (String)"columnFamily");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(keyInstance, (String)"keyInstance");
        Intrinsics.checkNotNullParameter(valueInstance, (String)"valueInstance");
        this.database = database;
        this.columnFamily = columnFamily;
        this.context = context;
        this.keyInstance = keyInstance;
        this.valueInstance = valueInstance;
        this.columnFamilyContext = new ColumnFamilyContext(((Enum)this.columnFamily).ordinal());
    }

    @NotNull
    public final TreeMap<Bytes, Bytes> getDatabase() {
        return this.database;
    }

    @NotNull
    public final ColumnFamilyNames getColumnFamily() {
        return this.columnFamily;
    }

    @NotNull
    public final TransactionContext getContext() {
        return this.context;
    }

    @NotNull
    public final KeyType getKeyInstance() {
        return this.keyInstance;
    }

    @NotNull
    public final ValueType getValueInstance() {
        return this.valueInstance;
    }

    private final void ensureInOpenTransaction(TransactionContext context, TransactionConsumer operation) {
        context.runInTransaction(() -> EzeDbColumnFamily.ensureInOpenTransaction$lambda-0(operation, context));
    }

    public void put(@NotNull KeyType key, @NotNull ValueType value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.ensureInOpenTransaction(this.context, arg_0 -> EzeDbColumnFamily.put$lambda-1(this, key, value, arg_0));
    }

    @Nullable
    public ValueType get(@NotNull KeyType key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.columnFamilyContext.writeKey((DbKey)key);
        DirectBuffer valueBuffer = this.getValue(this.context, this.columnFamilyContext);
        if (valueBuffer != null) {
            this.valueInstance.wrap(valueBuffer, 0, valueBuffer.capacity());
            return this.valueInstance;
        }
        return null;
    }

    private final DirectBuffer getValue(TransactionContext context, ColumnFamilyContext columnFamilyContext) {
        this.ensureInOpenTransaction(context, arg_0 -> EzeDbColumnFamily.getValue$lambda-2(columnFamilyContext, arg_0));
        return columnFamilyContext.getValueView();
    }

    public void forEach(@NotNull Consumer<ValueType> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.forEach(this.context, consumer);
    }

    public void forEach(@NotNull BiConsumer<KeyType, ValueType> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.forEach(this.context, consumer);
    }

    public void whileTrue(@NotNull KeyValuePairVisitor<KeyType, ValueType> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        this.whileTrue(this.context, visitor);
    }

    public void whileEqualPrefix(@NotNull DbKey keyPrefix, @NotNull BiConsumer<KeyType, ValueType> visitor) {
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        this.whileEqualPrefix(this.context, keyPrefix, visitor);
    }

    public void whileEqualPrefix(@NotNull DbKey keyPrefix, @NotNull KeyValuePairVisitor<KeyType, ValueType> visitor) {
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        this.whileEqualPrefix(this.context, keyPrefix, visitor);
    }

    public void delete(@NotNull KeyType key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.columnFamilyContext.writeKey((DbKey)key);
        this.ensureInOpenTransaction(this.context, arg_0 -> EzeDbColumnFamily.delete$lambda-3(this, arg_0));
    }

    public boolean exists(@NotNull KeyType key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.columnFamilyContext.wrapValueView(new byte[0]);
        this.ensureInOpenTransaction(this.context, arg_0 -> EzeDbColumnFamily.exists$lambda-4(this, key, arg_0));
        return !this.columnFamilyContext.isValueViewEmpty();
    }

    public boolean isEmpty() {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        this.whileEqualPrefix(this.context, this.keyInstance, this.valueInstance, (KeyValuePairVisitor<KeyType, ValueType>)((KeyValuePairVisitor)(arg_0, arg_1) -> EzeDbColumnFamily.isEmpty$lambda-5(isEmpty, arg_0, arg_1)));
        return isEmpty.get();
    }

    public final void forEach(@NotNull TransactionContext context, @NotNull Consumer<ValueType> consumer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, (BiConsumer<KeyType, ValueType>)((BiConsumer<DbKey, DbValue>)(arg_0, arg_1) -> EzeDbColumnFamily.forEach$lambda-6(consumer, arg_0, arg_1)));
    }

    public final void forEach(@NotNull TransactionContext context, @NotNull BiConsumer<KeyType, ValueType> consumer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, consumer);
    }

    private final void whileTrue(TransactionContext context, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, visitor);
    }

    private final void whileEqualPrefix(TransactionContext context, DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    private final void whileEqualPrefix(TransactionContext context, DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    private final EzeDbIterator newIterator(TransactionContext context) {
        ZeebeDbTransaction zeebeDbTransaction = context.getCurrentTransaction();
        if (zeebeDbTransaction == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.camunda.community.eze.db.EzeDbTransaction");
        }
        EzeDbTransaction currentTransaction = (EzeDbTransaction)zeebeDbTransaction;
        return currentTransaction.newIterator();
    }

    private final <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, prefix, keyInstance, valueInstance, (arg_0, arg_1) -> EzeDbColumnFamily.whileEqualPrefix$lambda-7(visitor, arg_0, arg_1));
    }

    private final <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, (DbKey)new DbNullKey(), keyInstance, valueInstance, (arg_0, arg_1) -> EzeDbColumnFamily.whileEqualPrefix$lambda-8(visitor, arg_0, arg_1));
    }

    private final <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, (DbKey)new DbNullKey(), keyInstance, valueInstance, visitor);
    }

    private final <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        DbKey dbKey = prefix;
        Intrinsics.checkNotNull((Object)dbKey);
        this.columnFamilyContext.withPrefixKey(dbKey, (arg_0, arg_1) -> EzeDbColumnFamily.whileEqualPrefix$lambda-11(this, context, keyInstance, valueInstance, visitor, arg_0, arg_1));
    }

    private final <KeyType extends DbKey, ValueType extends DbValue> boolean visit(KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> iteratorConsumer, Map.Entry<Bytes, Bytes> entry) {
        Bytes keyBytes = entry.getKey();
        this.columnFamilyContext.wrapKeyView(keyBytes.getByteArray());
        this.columnFamilyContext.wrapValueView(entry.getValue().getByteArray());
        DirectBuffer directBuffer = this.columnFamilyContext.getKeyView();
        Intrinsics.checkNotNull((Object)directBuffer);
        DirectBuffer keyViewBuffer = directBuffer;
        KeyType KeyType = keyInstance;
        Intrinsics.checkNotNull(KeyType);
        KeyType.wrap(keyViewBuffer, 0, keyViewBuffer.capacity());
        DirectBuffer directBuffer2 = this.columnFamilyContext.getValueView();
        Intrinsics.checkNotNull((Object)directBuffer2);
        DirectBuffer valueViewBuffer = directBuffer2;
        ValueType ValueType2 = valueInstance;
        Intrinsics.checkNotNull(ValueType2);
        ValueType2.wrap(valueViewBuffer, 0, valueViewBuffer.capacity());
        return iteratorConsumer.visit(keyInstance, valueInstance);
    }

    private static final void ensureInOpenTransaction$lambda-0(TransactionConsumer $operation, TransactionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        ZeebeDbTransaction zeebeDbTransaction = $context.getCurrentTransaction();
        if (zeebeDbTransaction == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.camunda.community.eze.db.EzeDbTransaction");
        }
        $operation.run((EzeDbTransaction)zeebeDbTransaction);
    }

    private static final void put$lambda-1(EzeDbColumnFamily this$0, DbKey $key, DbValue $value, EzeDbTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this$0.columnFamilyContext.writeKey($key);
        this$0.columnFamilyContext.writeValue($value);
        transaction.put(this$0.columnFamilyContext.getKeyBufferArray(), this$0.columnFamilyContext.getKeyLength(), this$0.columnFamilyContext.getValueBufferArray(), $value.getLength());
    }

    private static final void getValue$lambda-2(ColumnFamilyContext $columnFamilyContext, EzeDbTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)$columnFamilyContext, (String)"$columnFamilyContext");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        byte[] value = transaction.get($columnFamilyContext.getKeyBufferArray(), $columnFamilyContext.getKeyLength());
        $columnFamilyContext.wrapValueView(value);
    }

    private static final void delete$lambda-3(EzeDbColumnFamily this$0, EzeDbTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        transaction.delete(this$0.columnFamilyContext.getKeyBufferArray(), this$0.columnFamilyContext.getKeyLength());
    }

    private static final void exists$lambda-4(EzeDbColumnFamily this$0, DbKey $key, EzeDbTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this$0.columnFamilyContext.writeKey($key);
        this$0.getValue(this$0.getContext(), this$0.columnFamilyContext);
    }

    private static final boolean isEmpty$lambda-5(AtomicBoolean $isEmpty, DbKey key, DbValue value) {
        Intrinsics.checkNotNullParameter((Object)$isEmpty, (String)"$isEmpty");
        $isEmpty.set(false);
        return false;
    }

    private static final void forEach$lambda-6(Consumer $consumer, DbKey ignore, DbValue value) {
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        Intrinsics.checkNotNullParameter((Object)ignore, (String)"ignore");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $consumer.accept(value);
    }

    private static final boolean whileEqualPrefix$lambda-7(BiConsumer $visitor, DbKey k, DbValue v) {
        Intrinsics.checkNotNullParameter((Object)$visitor, (String)"$visitor");
        $visitor.accept(k, v);
        return true;
    }

    private static final boolean whileEqualPrefix$lambda-8(BiConsumer $visitor, DbKey k, DbValue v) {
        Intrinsics.checkNotNullParameter((Object)$visitor, (String)"$visitor");
        $visitor.accept(k, v);
        return true;
    }

    private static final void whileEqualPrefix$lambda-11$lambda-10(byte[] $prefixKey, int $prefixLength, EzeDbColumnFamily this$0, DbKey $keyInstance, DbValue $valueInstance, KeyValuePairVisitor $visitor, EzeDbTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$visitor, (String)"$visitor");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        EzeDbIterator ezeDbIterator = transaction.newIterator();
        Intrinsics.checkNotNull((Object)$prefixKey);
        Iterator<Map.Entry<Bytes, Bytes>> $this$forEach$iv = ezeDbIterator.seek($prefixKey, $prefixLength).iterate();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Bytes, Bytes>> iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<Bytes, Bytes>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            boolean shouldVisitNext;
            Map.Entry<Bytes, Bytes> element$iv;
            Map.Entry<Bytes, Bytes> it = element$iv = iterator2.next();
            boolean bl2 = false;
            byte[] keyBytes = it.getKey().getByteArray();
            if (!BufferUtil.startsWith((byte[])$prefixKey, (int)0, (int)$prefixLength, (byte[])keyBytes, (int)0, (int)keyBytes.length) || (shouldVisitNext = this$0.visit($keyInstance, $valueInstance, $visitor, it))) continue;
            return;
        }
    }

    private static final void whileEqualPrefix$lambda-11(EzeDbColumnFamily this$0, TransactionContext $context, DbKey $keyInstance, DbValue $valueInstance, KeyValuePairVisitor $visitor, byte[] prefixKey, int prefixLength) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$visitor, (String)"$visitor");
        this$0.ensureInOpenTransaction($context, arg_0 -> EzeDbColumnFamily.whileEqualPrefix$lambda-11$lambda-10(prefixKey, prefixLength, this$0, $keyInstance, $valueInstance, $visitor, arg_0));
    }
}

