/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze;

import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Configuration;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.exporter.api.context.ScheduledTask;
import io.camunda.zeebe.protocol.record.Record;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001c\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00030\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\rR\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/camunda/community/eze/ExporterRunner;", "Ljava/lang/AutoCloseable;", "exporters", "", "Lio/camunda/zeebe/exporter/api/Exporter;", "reader", "Lkotlin/Function1;", "", "Lio/camunda/zeebe/protocol/record/Record;", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)V", "controller", "Lorg/camunda/community/eze/ExporterRunner$ExporterController;", "", "Lorg/camunda/community/eze/ExporterRunner$ExporterContext;", "lastPosition", "getReader", "()Lkotlin/jvm/functions/Function1;", "close", "", "onRecordsAvailable", "open", "ExporterConfiguration", "ExporterContext", "ExporterController", "eze"})
public final class ExporterRunner
implements AutoCloseable {
    @NotNull
    private final Function1<Long, Iterable<Record<?>>> reader;
    @NotNull
    private final ExporterController controller;
    @NotNull
    private final Map<Exporter, ExporterContext> exporters;
    private long lastPosition;

    /*
     * WARNING - void declaration
     */
    public ExporterRunner(@NotNull Iterable<? extends Exporter> exporters, @NotNull Function1<? super Long, ? extends Iterable<? extends Record<?>>> reader) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(exporters, (String)"exporters");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.reader = reader;
        this.controller = new ExporterController();
        Iterable<? extends Exporter> iterable = exporters;
        ExporterRunner exporterRunner2 = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Exporter exporter = (Exporter)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            ExporterContext exporterContext = new ExporterContext((Exporter)it);
            map.put(t, exporterContext);
        }
        exporterRunner2.exporters = result$iv;
        this.lastPosition = -1L;
    }

    @NotNull
    public final Function1<Long, Iterable<Record<?>>> getReader() {
        return this.reader;
    }

    public final void open() {
        Map<Exporter, ExporterContext> $this$forEach$iv = this.exporters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Exporter, ExporterContext>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Exporter, ExporterContext> element$iv;
            Map.Entry<Exporter, ExporterContext> $dstr$exporter$context = element$iv = iterator.next();
            boolean bl = false;
            Exporter exporter = $dstr$exporter$context.getKey();
            ExporterContext context = $dstr$exporter$context.getValue();
            exporter.configure((Context)context);
            exporter.open((Controller)this.controller);
        }
    }

    @Override
    public void close() {
        Map<Exporter, ExporterContext> $this$forEach$iv = this.exporters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Exporter, ExporterContext>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Exporter, ExporterContext> element$iv;
            Map.Entry<Exporter, ExporterContext> $dstr$exporter$_u24__u24 = element$iv = iterator.next();
            boolean bl = false;
            Exporter exporter = $dstr$exporter$_u24__u24.getKey();
            exporter.close();
        }
        this.controller.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void onRecordsAvailable() {
        Iterable $this$forEach$iv = (Iterable)this.reader.invoke((Object)this.lastPosition);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            Record record = (Record)element$iv;
            boolean bl = false;
            Map<Exporter, ExporterContext> map = this.exporters;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                Map.Entry element$iv$iv;
                Map.Entry $dstr$_u24__u24$context = element$iv$iv = iterator2.next();
                boolean bl3 = false;
                ExporterContext context = (ExporterContext)$dstr$_u24__u24$context.getValue();
                Context.RecordFilter recordFilter = context.getRecordFilter();
                if (recordFilter == null) {
                    bl2 = true;
                } else {
                    boolean bl4;
                    Context.RecordFilter it = recordFilter;
                    boolean bl5 = false;
                    bl2 = bl4 = it.acceptType(record.getRecordType()) && it.acceptValue(record.getValueType());
                }
                if (!bl2) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry $dstr$exporter$context = element$iv2 = iterator.next();
                boolean bl6 = false;
                Exporter exporter = (Exporter)$dstr$exporter$context.getKey();
                ExporterContext context = (ExporterContext)$dstr$exporter$context.getValue();
                exporter.export(record);
            }
            this.lastPosition = record.getPosition();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/camunda/community/eze/ExporterRunner$ExporterContext;", "Lio/camunda/zeebe/exporter/api/context/Context;", "exporter", "Lio/camunda/zeebe/exporter/api/Exporter;", "(Lorg/camunda/community/eze/ExporterRunner;Lio/camunda/zeebe/exporter/api/Exporter;)V", "getExporter", "()Lio/camunda/zeebe/exporter/api/Exporter;", "recordFilter", "Lio/camunda/zeebe/exporter/api/context/Context$RecordFilter;", "getRecordFilter", "()Lio/camunda/zeebe/exporter/api/context/Context$RecordFilter;", "setRecordFilter", "(Lio/camunda/zeebe/exporter/api/context/Context$RecordFilter;)V", "getConfiguration", "Lio/camunda/zeebe/exporter/api/context/Configuration;", "getLogger", "Lorg/slf4j/Logger;", "setFilter", "", "filter", "eze"})
    public final class ExporterContext
    implements Context {
        @NotNull
        private final Exporter exporter;
        @Nullable
        private Context.RecordFilter recordFilter;

        public ExporterContext(Exporter exporter) {
            Intrinsics.checkNotNullParameter((Object)ExporterRunner.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
            this.exporter = exporter;
        }

        @NotNull
        public final Exporter getExporter() {
            return this.exporter;
        }

        @Nullable
        public final Context.RecordFilter getRecordFilter() {
            return this.recordFilter;
        }

        public final void setRecordFilter(@Nullable Context.RecordFilter recordFilter) {
            this.recordFilter = recordFilter;
        }

        @NotNull
        public Logger getLogger() {
            Logger logger = LoggerFactory.getLogger(this.exporter.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(exporter::class.java)");
            return logger;
        }

        @NotNull
        public Configuration getConfiguration() {
            return new ExporterConfiguration(this.exporter);
        }

        public void setFilter(@Nullable Context.RecordFilter filter) {
            this.recordFilter = filter;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J!\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/camunda/community/eze/ExporterRunner$ExporterConfiguration;", "Lio/camunda/zeebe/exporter/api/context/Configuration;", "exporter", "Lio/camunda/zeebe/exporter/api/Exporter;", "(Lorg/camunda/community/eze/ExporterRunner;Lio/camunda/zeebe/exporter/api/Exporter;)V", "getExporter", "()Lio/camunda/zeebe/exporter/api/Exporter;", "getArguments", "", "", "", "getId", "instantiate", "T", "configClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "eze"})
    public final class ExporterConfiguration
    implements Configuration {
        @NotNull
        private final Exporter exporter;

        public ExporterConfiguration(Exporter exporter) {
            Intrinsics.checkNotNullParameter((Object)ExporterRunner.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
            this.exporter = exporter;
        }

        @NotNull
        public final Exporter getExporter() {
            return this.exporter;
        }

        @NotNull
        public String getId() {
            String string = this.exporter.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exporter::class.java.simpleName");
            return string;
        }

        @NotNull
        public Map<String, Object> getArguments() {
            return new LinkedHashMap();
        }

        public <T> T instantiate(@NotNull Class<T> configClass) {
            Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
            return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/camunda/community/eze/ExporterRunner$ExporterController;", "Lio/camunda/zeebe/exporter/api/context/Controller;", "Ljava/lang/AutoCloseable;", "(Lorg/camunda/community/eze/ExporterRunner;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "close", "", "scheduleCancellableTask", "Lio/camunda/zeebe/exporter/api/context/ScheduledTask;", "delay", "Ljava/time/Duration;", "task", "Ljava/lang/Runnable;", "updateLastExportedRecordPosition", "position", "", "eze"})
    public final class ExporterController
    implements Controller,
    AutoCloseable {
        private final ScheduledExecutorService executor;

        public ExporterController() {
            Intrinsics.checkNotNullParameter((Object)ExporterRunner.this, (String)"this$0");
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }

        public final ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        public void updateLastExportedRecordPosition(long position) {
        }

        @NotNull
        public ScheduledTask scheduleCancellableTask(@NotNull Duration delay, @NotNull Runnable task) {
            Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(task, 0L, delay.toMillis(), TimeUnit.MILLISECONDS);
            return () -> ExporterController.scheduleCancellableTask$lambda-0(future);
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }

        private static final void scheduleCancellableTask$lambda-0(ScheduledFuture $future) {
            $future.cancel(true);
        }
    }
}

