/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.db;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbNil;
import java.io.File;
import java.util.Optional;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.db.Bytes;
import org.camunda.community.eze.db.DbNullKey;
import org.camunda.community.eze.db.EzeDbColumnFamily;
import org.camunda.community.eze.db.EzeDbTransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016JM\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0001\u0010\f*\u00020\u000e\"\b\b\u0002\u0010\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\f2\u0006\u0010\u0014\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0012\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010!R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/camunda/community/eze/db/EzeDb;", "ColumnFamilyType", "", "Lio/camunda/zeebe/db/ZeebeDb;", "()V", "database", "Ljava/util/TreeMap;", "Lorg/camunda/community/eze/db/Bytes;", "close", "", "createColumnFamily", "Lio/camunda/zeebe/db/ColumnFamily;", "KeyType", "ValueType", "Lio/camunda/zeebe/db/DbKey;", "Lio/camunda/zeebe/db/DbValue;", "columnFamily", "context", "Lio/camunda/zeebe/db/TransactionContext;", "keyInstance", "valueInstance", "(Ljava/lang/Enum;Lio/camunda/zeebe/db/TransactionContext;Lio/camunda/zeebe/db/DbKey;Lio/camunda/zeebe/db/DbValue;)Lio/camunda/zeebe/db/ColumnFamily;", "createContext", "createSnapshot", "snapshotDir", "Ljava/io/File;", "getProperty", "Ljava/util/Optional;", "", "propertyName", "isEmpty", "", "column", "(Ljava/lang/Enum;Lio/camunda/zeebe/db/TransactionContext;)Z", "eze"})
public final class EzeDb<ColumnFamilyType extends Enum<ColumnFamilyType>>
implements ZeebeDb<ColumnFamilyType> {
    @NotNull
    private final TreeMap<Bytes, Bytes> database = new TreeMap();

    public void close() {
        this.database.clear();
    }

    @NotNull
    public <KeyType extends DbKey, ValueType extends DbValue> ColumnFamily<KeyType, ValueType> createColumnFamily(@NotNull ColumnFamilyType columnFamily, @NotNull TransactionContext context, @NotNull KeyType keyInstance, @NotNull ValueType valueInstance) {
        Intrinsics.checkNotNullParameter(columnFamily, (String)"columnFamily");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(keyInstance, (String)"keyInstance");
        Intrinsics.checkNotNullParameter(valueInstance, (String)"valueInstance");
        return new EzeDbColumnFamily<ColumnFamilyType, KeyType, ValueType>(this.database, columnFamily, context, keyInstance, valueInstance);
    }

    @NotNull
    public TransactionContext createContext() {
        return new EzeDbTransactionContext(this.database);
    }

    public void createSnapshot(@Nullable File snapshotDir) {
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"No snapshots supported"));
    }

    @NotNull
    public Optional<String> getProperty(@Nullable String propertyName) {
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    public boolean isEmpty(@NotNull ColumnFamilyType column, @NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.createColumnFamily(column, context, (DbKey)DbNullKey.Companion.getINSTANCE(), (DbValue)DbNil.INSTANCE).isEmpty();
    }
}

