/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.db;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.db.Bytes;
import org.camunda.community.eze.db.EzeDbTransactionKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\u0010'\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\tJ\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/eze/db/EzeDbIterator;", "", "database", "Ljava/util/SortedMap;", "Lorg/camunda/community/eze/db/Bytes;", "(Ljava/util/SortedMap;)V", "getDatabase", "()Ljava/util/SortedMap;", "iterate", "", "", "seek", "prefix", "", "prefixLength", "", "eze"})
public final class EzeDbIterator {
    @NotNull
    private final SortedMap<Bytes, Bytes> database;

    public EzeDbIterator(@NotNull SortedMap<Bytes, Bytes> database) {
        Intrinsics.checkNotNullParameter(database, (String)"database");
        this.database = database;
    }

    @NotNull
    public final SortedMap<Bytes, Bytes> getDatabase() {
        return this.database;
    }

    @NotNull
    public final EzeDbIterator seek(@NotNull byte[] prefix, int prefixLength) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        SortedMap<Bytes, Bytes> sortedMap = this.database.tailMap(EzeDbTransactionKt.toBytes(prefix, prefixLength));
        Intrinsics.checkNotNullExpressionValue(sortedMap, (String)"database.tailMap(prefix.toBytes(prefixLength))");
        return new EzeDbIterator(sortedMap);
    }

    @NotNull
    public final Iterator<Map.Entry<Bytes, Bytes>> iterate() {
        return ((Map)this.database).entrySet().iterator();
    }
}

