/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.grpc.EzeGateway;
import org.camunda.community.eze.grpc.GrpcResponseWriter;
import org.camunda.community.eze.grpc.GrpcToLogStreamGateway;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/camunda/community/eze/grpc/EzeGatewayFactory;", "", "()V", "createGateway", "Lorg/camunda/community/eze/grpc/EzeGateway;", "port", "", "streamWriter", "Lio/camunda/zeebe/logstreams/log/LogStreamRecordWriter;", "eze"})
public final class EzeGatewayFactory {
    @NotNull
    public static final EzeGatewayFactory INSTANCE = new EzeGatewayFactory();

    private EzeGatewayFactory() {
    }

    @NotNull
    public final EzeGateway createGateway(int port, @NotNull LogStreamRecordWriter streamWriter) {
        Intrinsics.checkNotNullParameter((Object)streamWriter, (String)"streamWriter");
        GrpcToLogStreamGateway gateway = new GrpcToLogStreamGateway(streamWriter);
        Server grpcServer = ServerBuilder.forPort((int)port).addService((BindableService)gateway).build();
        GrpcResponseWriter grpcResponseWriter2 = new GrpcResponseWriter((Function2<? super Long, ? super GeneratedMessageV3, Unit>)((Function2)new Function2<Long, GeneratedMessageV3, Unit>((Object)gateway){

            public final void invoke(long p0, @NotNull GeneratedMessageV3 p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((GrpcToLogStreamGateway)this.receiver).responseCallback(p0, p1);
            }
        }), (Function2<? super Long, ? super Status, Unit>)((Function2)new Function2<Long, Status, Unit>((Object)gateway){

            public final void invoke(long p0, @NotNull Status p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((GrpcToLogStreamGateway)this.receiver).errorCallback(p0, p1);
            }
        }), (Function1<? super Long, ? extends Class<? extends GeneratedMessageV3>>)((Function1)new Function1<Long, Class<? extends GeneratedMessageV3>>((Object)gateway){

            @Nullable
            public final Class<? extends GeneratedMessageV3> invoke(long p0) {
                return ((GrpcToLogStreamGateway)this.receiver).getExpectedResponseType(p0);
            }
        }));
        Runnable runnable = () -> EzeGatewayFactory.createGateway$lambda$0(grpcServer);
        Runnable runnable2 = () -> EzeGatewayFactory.createGateway$lambda$1(grpcServer, gateway);
        return new EzeGateway(grpcResponseWriter2, runnable, runnable2);
    }

    private static final void createGateway$lambda$0(Server $grpcServer) {
        $grpcServer.start();
    }

    private static final void createGateway$lambda$1(Server $grpcServer, GrpcToLogStreamGateway $gateway) {
        Intrinsics.checkNotNullParameter((Object)$gateway, (String)"$gateway");
        $grpcServer.shutdownNow();
        $grpcServer.awaitTermination();
        $gateway.close();
    }
}

