/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. See the NOTICE file distributed
 * with this work for additional information regarding copyright ownership.
 * Licensed under the Zeebe Community License 1.1. You may not use this file
 * except in compliance with the Zeebe Community License 1.1.
 */
package org.camunda.community.eze.db

import java.util.*

class EzeDbIterator(val database : SortedMap<Bytes, Bytes>) {


    fun seek(prefix: ByteArray, prefixLength: Int) : EzeDbIterator {
        return EzeDbIterator(database.tailMap(prefix.toBytes(prefixLength)))
    }

    fun iterate() : MutableIterator<MutableMap.MutableEntry<Bytes, Bytes>> {
        return database.iterator()
    }

}
