/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.Engine;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.stream.impl.StreamProcessorMode;
import io.camunda.zeebe.util.FeatureFlags;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.db.EzeZeebeDbFactory;
import org.camunda.community.eze.engine.EzeLogStream;
import org.camunda.community.eze.engine.EzeStreamProcessor;
import org.camunda.community.eze.engine.EzeStreamProcessorFactory;
import org.camunda.community.eze.engine.SinglePartitionCommandSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/camunda/community/eze/engine/EzeStreamProcessorFactory;", "", "()V", "createDatabase", "Lio/camunda/zeebe/db/ZeebeDb;", "Lio/camunda/zeebe/protocol/ZbColumnFamilies;", "createPartitionCommandSender", "Lio/camunda/zeebe/stream/api/InterPartitionCommandSender;", "logStream", "Lorg/camunda/community/eze/engine/EzeLogStream;", "createRecordProcessorsFactory", "Lkotlin/Function1;", "Lio/camunda/zeebe/engine/processing/streamprocessor/TypedRecordProcessorContext;", "Lio/camunda/zeebe/engine/processing/streamprocessor/TypedRecordProcessors;", "partitionCount", "", "createStreamProcessor", "Lorg/camunda/community/eze/engine/EzeStreamProcessor;", "responseWriter", "Lio/camunda/zeebe/stream/api/CommandResponseWriter;", "scheduler", "Lio/camunda/zeebe/scheduler/ActorSchedulingService;", "createZeebeEngine", "Lio/camunda/zeebe/engine/Engine;", "eze"})
public final class EzeStreamProcessorFactory {
    @NotNull
    public static final EzeStreamProcessorFactory INSTANCE = new EzeStreamProcessorFactory();

    private EzeStreamProcessorFactory() {
    }

    @NotNull
    public final EzeStreamProcessor createStreamProcessor(@NotNull EzeLogStream logStream, @NotNull CommandResponseWriter responseWriter, @NotNull ActorSchedulingService scheduler, int partitionCount) {
        Intrinsics.checkNotNullParameter((Object)logStream, (String)"logStream");
        Intrinsics.checkNotNullParameter((Object)responseWriter, (String)"responseWriter");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        ZeebeDb<ZbColumnFamilies> zeebeDb = this.createDatabase();
        StreamProcessor streamProcessor = StreamProcessor.builder().logStream(logStream.getZeebeLogStream()).zeebeDb(zeebeDb).commandResponseWriter(responseWriter).partitionCommandSender(this.createPartitionCommandSender(logStream)).nodeId(0).actorSchedulingService(scheduler).streamProcessorMode(StreamProcessorMode.PROCESSING).recordProcessors(CollectionsKt.listOf((Object)this.createZeebeEngine(partitionCount))).build();
        return new EzeStreamProcessor(() -> EzeStreamProcessorFactory.createStreamProcessor$lambda$0(streamProcessor), () -> EzeStreamProcessorFactory.createStreamProcessor$lambda$1(streamProcessor, zeebeDb));
    }

    private final ZeebeDb<ZbColumnFamilies> createDatabase() {
        ZeebeDbFactory zeebeDbFactory = EzeZeebeDbFactory.getDefaultFactory();
        ZeebeDb zeebeDb = zeebeDbFactory.createDb(Files.createTempDirectory("zeebeDb", new FileAttribute[0]).toFile());
        Intrinsics.checkNotNullExpressionValue((Object)zeebeDb, (String)"zeebeDbFactory.createDb(\u2026tory(\"zeebeDb\").toFile())");
        return zeebeDb;
    }

    private final Engine createZeebeEngine(int partitionCount) {
        return new Engine(arg_0 -> EzeStreamProcessorFactory.createZeebeEngine$lambda$2(this.createRecordProcessorsFactory(partitionCount), arg_0));
    }

    private final Function1<TypedRecordProcessorContext, TypedRecordProcessors> createRecordProcessorsFactory(int partitionCount) {
        return (Function1)new Function1<TypedRecordProcessorContext, TypedRecordProcessors>(partitionCount){
            final /* synthetic */ int $partitionCount;
            {
                this.$partitionCount = $partitionCount;
                super(1);
            }

            public final TypedRecordProcessors invoke(@NotNull TypedRecordProcessorContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TypedRecordProcessors typedRecordProcessors = EngineProcessors.createEngineProcessors((TypedRecordProcessorContext)context, (int)this.$partitionCount, (SubscriptionCommandSender)new SubscriptionCommandSender(context.getPartitionId(), context.getPartitionCommandSender()), (DeploymentDistributionCommandSender)new DeploymentDistributionCommandSender(context.getPartitionId(), context.getPartitionCommandSender()), createRecordProcessorsFactory.1::invoke$lambda$0, (FeatureFlags)FeatureFlags.createDefault());
                Intrinsics.checkNotNullExpressionValue((Object)typedRecordProcessors, (String)"createEngineProcessors(\n\u2026teDefault()\n            )");
                return typedRecordProcessors;
            }

            private static final void invoke$lambda$0(String jobType) {
            }
        };
    }

    private final InterPartitionCommandSender createPartitionCommandSender(EzeLogStream logStream) {
        Map streamWriters = MapsKt.mapOf((Pair)TuplesKt.to((Object)logStream.getZeebeLogStream().getPartitionId(), (Object)logStream.createWriter()));
        return new SinglePartitionCommandSender((Function1<? super Integer, ? extends LogStreamWriter>)((Function1)new Function1<Integer, LogStreamWriter>((Map<Integer, ? extends LogStreamWriter>)streamWriters){
            final /* synthetic */ Map<Integer, LogStreamWriter> $streamWriters;
            {
                this.$streamWriters = $streamWriters;
                super(1);
            }

            @NotNull
            public final LogStreamWriter invoke(int partitionId) {
                LogStreamWriter logStreamWriter = this.$streamWriters.get(partitionId);
                if (logStreamWriter == null) {
                    throw new RuntimeException("no stream writer found for partition '" + partitionId + "'");
                }
                return logStreamWriter;
            }
        }));
    }

    private static final void createStreamProcessor$lambda$0(StreamProcessor $streamProcessor) {
        $streamProcessor.openAsync(false).join();
    }

    private static final void createStreamProcessor$lambda$1(StreamProcessor $streamProcessor, ZeebeDb $zeebeDb) {
        Intrinsics.checkNotNullParameter((Object)$zeebeDb, (String)"$zeebeDb");
        $streamProcessor.close();
        $zeebeDb.close();
    }

    private static final TypedRecordProcessors createZeebeEngine$lambda$2(Function1 $tmp0, TypedRecordProcessorContext typedRecordProcessorContext) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TypedRecordProcessors)$tmp0.invoke((Object)typedRecordProcessorContext);
    }
}

