/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.db;

import io.camunda.zeebe.db.TransactionOperation;
import io.camunda.zeebe.db.ZeebeDbTransaction;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.eze.db.Bytes;
import org.camunda.community.eze.db.EzeDbIterator;
import org.camunda.community.eze.db.EzeDbTransactionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0014J\u0006\u0010\u001c\u001a\u00020\u000eJ\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/camunda/community/eze/db/EzeDbTransaction;", "Lio/camunda/zeebe/db/ZeebeDbTransaction;", "database", "Ljava/util/TreeMap;", "Lorg/camunda/community/eze/db/Bytes;", "(Ljava/util/TreeMap;)V", "getDatabase", "()Ljava/util/TreeMap;", "deletedKeys", "Ljava/util/HashSet;", "inCurrentTransaction", "", "transactionCache", "close", "", "commit", "delete", "keyBufferArray", "", "keyLength", "", "get", "isInCurrentTransaction", "newIterator", "Lorg/camunda/community/eze/db/EzeDbIterator;", "put", "valueBufferArray", "valueLength", "resetTransaction", "rollback", "run", "operations", "Lio/camunda/zeebe/db/TransactionOperation;", "eze"})
@SourceDebugExtension(value={"SMAP\nEzeDbTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EzeDbTransaction.kt\norg/camunda/community/eze/db/EzeDbTransaction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1855#2,2:87\n*S KotlinDebug\n*F\n+ 1 EzeDbTransaction.kt\norg/camunda/community/eze/db/EzeDbTransaction\n*L\n40#1:87,2\n*E\n"})
public final class EzeDbTransaction
implements ZeebeDbTransaction {
    @NotNull
    private final TreeMap<Bytes, Bytes> database;
    @NotNull
    private final TreeMap<Bytes, Bytes> transactionCache;
    @NotNull
    private final HashSet<Bytes> deletedKeys;
    private boolean inCurrentTransaction;

    public EzeDbTransaction(@NotNull TreeMap<Bytes, Bytes> database) {
        Intrinsics.checkNotNullParameter(database, (String)"database");
        this.database = database;
        this.transactionCache = new TreeMap();
        this.deletedKeys = new HashSet();
    }

    @NotNull
    public final TreeMap<Bytes, Bytes> getDatabase() {
        return this.database;
    }

    public final void resetTransaction() {
        this.rollback();
        this.inCurrentTransaction = true;
    }

    public final boolean isInCurrentTransaction() {
        return this.inCurrentTransaction;
    }

    public void run(@NotNull TransactionOperation operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        operations.run();
    }

    public void commit() {
        this.inCurrentTransaction = false;
        this.database.putAll((Map<Bytes, Bytes>)this.transactionCache);
        Iterable $this$forEach$iv = this.deletedKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bytes it = (Bytes)element$iv;
            boolean bl = false;
            this.database.remove(it);
        }
        this.deletedKeys.clear();
        this.transactionCache.clear();
    }

    public void rollback() {
        this.inCurrentTransaction = false;
        this.transactionCache.clear();
        this.deletedKeys.clear();
    }

    public final void close() {
        this.transactionCache.clear();
    }

    public final void put(@NotNull byte[] keyBufferArray, int keyLength, @NotNull byte[] valueBufferArray, int valueLength) {
        Intrinsics.checkNotNullParameter((Object)keyBufferArray, (String)"keyBufferArray");
        Intrinsics.checkNotNullParameter((Object)valueBufferArray, (String)"valueBufferArray");
        Bytes keyBytes = EzeDbTransactionKt.toBytes(keyBufferArray, keyLength);
        this.deletedKeys.remove(keyBytes);
        ((Map)this.transactionCache).put(keyBytes, EzeDbTransactionKt.toBytes(valueBufferArray, valueLength));
    }

    @Nullable
    public final byte[] get(@NotNull byte[] keyBufferArray, int keyLength) {
        Bytes valueInCache;
        Intrinsics.checkNotNullParameter((Object)keyBufferArray, (String)"keyBufferArray");
        Bytes keyBytes = EzeDbTransactionKt.toBytes(keyBufferArray, keyLength);
        Bytes bytes = valueInCache = this.transactionCache.get(keyBytes);
        if (bytes != null) {
            Bytes it = bytes;
            boolean bl = false;
            return valueInCache.getByteArray();
        }
        Bytes bytes2 = this.database.get(keyBytes);
        return (byte[])(bytes2 != null ? bytes2.getByteArray() : null);
    }

    public final void delete(@NotNull byte[] keyBufferArray, int keyLength) {
        Intrinsics.checkNotNullParameter((Object)keyBufferArray, (String)"keyBufferArray");
        Bytes keyBytes = EzeDbTransactionKt.toBytes(keyBufferArray, keyLength);
        this.transactionCache.remove(keyBytes);
        this.deletedKeys.add(keyBytes);
    }

    @NotNull
    public final EzeDbIterator newIterator() {
        TreeMap map = new TreeMap();
        map.putAll(this.database);
        map.putAll(this.transactionCache);
        return new EzeDbIterator(map);
    }
}

