/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.db;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.TransactionOperation;
import io.camunda.zeebe.db.ZeebeDbTransaction;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.db.Bytes;
import org.camunda.community.eze.db.EzeDbTransaction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/camunda/community/eze/db/EzeDbTransactionContext;", "Lio/camunda/zeebe/db/TransactionContext;", "database", "Ljava/util/TreeMap;", "Lorg/camunda/community/eze/db/Bytes;", "(Ljava/util/TreeMap;)V", "getDatabase", "()Ljava/util/TreeMap;", "transaction", "Lorg/camunda/community/eze/db/EzeDbTransaction;", "getCurrentTransaction", "Lio/camunda/zeebe/db/ZeebeDbTransaction;", "runInNewTransaction", "", "operations", "Lio/camunda/zeebe/db/TransactionOperation;", "runInTransaction", "eze"})
public final class EzeDbTransactionContext
implements TransactionContext {
    @NotNull
    private final TreeMap<Bytes, Bytes> database;
    @NotNull
    private final EzeDbTransaction transaction;

    public EzeDbTransactionContext(@NotNull TreeMap<Bytes, Bytes> database) {
        Intrinsics.checkNotNullParameter(database, (String)"database");
        this.database = database;
        this.transaction = new EzeDbTransaction(this.database);
    }

    @NotNull
    public final TreeMap<Bytes, Bytes> getDatabase() {
        return this.database;
    }

    public void runInTransaction(@NotNull TransactionOperation operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        try {
            if (this.transaction.isInCurrentTransaction()) {
                operations.run();
            } else {
                this.runInNewTransaction(operations);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected error occurred during zeebe db transaction operation.", ex);
        }
    }

    @NotNull
    public ZeebeDbTransaction getCurrentTransaction() {
        if (!this.transaction.isInCurrentTransaction()) {
            this.transaction.resetTransaction();
        }
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runInNewTransaction(TransactionOperation operations) {
        try {
            this.transaction.resetTransaction();
            operations.run();
            this.transaction.commit();
        }
        finally {
            this.transaction.rollback();
        }
    }
}

