/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.eze.engine;

import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.agrona.DirectBuffer;
import org.camunda.community.eze.engine.InMemoryLogStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J(\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/camunda/community/eze/engine/InMemoryLogStorage;", "Lio/camunda/zeebe/logstreams/storage/LogStorage;", "()V", "commitListeners", "", "Lio/camunda/zeebe/logstreams/storage/LogStorage$CommitListener;", "entries", "", "Lorg/camunda/community/eze/engine/InMemoryLogStorage$Entry;", "positionIndexMapping", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "", "addCommitListener", "", "listener", "append", "lowestPosition", "highestPosition", "bufferWriter", "Lio/camunda/zeebe/util/buffer/BufferWriter;", "Lio/camunda/zeebe/logstreams/storage/LogStorage$AppendListener;", "newReader", "Lio/camunda/zeebe/logstreams/storage/LogStorageReader;", "removeCommitListener", "Entry", "ListLogStorageReader", "eze"})
@SourceDebugExtension(value={"SMAP\nInMemoryLogStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryLogStorage.kt\norg/camunda/community/eze/engine/InMemoryLogStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1855#2,2:95\n*S KotlinDebug\n*F\n+ 1 InMemoryLogStorage.kt\norg/camunda/community/eze/engine/InMemoryLogStorage\n*L\n53#1:95,2\n*E\n"})
public final class InMemoryLogStorage
implements LogStorage {
    @NotNull
    private final ConcurrentSkipListMap<Long, Integer> positionIndexMapping = new ConcurrentSkipListMap();
    @NotNull
    private final List<Entry> entries = new ArrayList();
    @NotNull
    private final Set<LogStorage.CommitListener> commitListeners = new LinkedHashSet();

    @NotNull
    public LogStorageReader newReader() {
        return new ListLogStorageReader();
    }

    public void addCommitListener(@NotNull LogStorage.CommitListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(@NotNull LogStorage.CommitListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.commitListeners.remove(listener);
    }

    public void append(long lowestPosition, long highestPosition, @NotNull BufferWriter bufferWriter, @NotNull LogStorage.AppendListener listener) {
        Intrinsics.checkNotNullParameter((Object)bufferWriter, (String)"bufferWriter");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        try {
            DirectBuffer directBuffer = BufferUtil.createCopy((BufferWriter)bufferWriter);
            Intrinsics.checkNotNullExpressionValue((Object)directBuffer, (String)"createCopy(bufferWriter)");
            DirectBuffer copy = directBuffer;
            Entry entry = new Entry(copy);
            this.entries.add(entry);
            int index = this.entries.size();
            Long l = lowestPosition;
            Integer n = index;
            ((Map)this.positionIndexMapping).put(l, n);
            listener.onWrite((long)index);
            listener.onCommit((long)index);
            Iterable $this$forEach$iv = this.commitListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LogStorage.CommitListener p0 = (LogStorage.CommitListener)element$iv;
                boolean bl = false;
                p0.onCommit();
            }
        }
        catch (Exception e) {
            listener.onWriteError((Throwable)e);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/eze/engine/InMemoryLogStorage$Entry;", "", "data", "Lorg/agrona/DirectBuffer;", "(Lorg/agrona/DirectBuffer;)V", "getData", "()Lorg/agrona/DirectBuffer;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "eze"})
    private static final class Entry {
        @NotNull
        private final DirectBuffer data;

        public Entry(@NotNull DirectBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final DirectBuffer getData() {
            return this.data;
        }

        @NotNull
        public final DirectBuffer component1() {
            return this.data;
        }

        @NotNull
        public final Entry copy(@NotNull DirectBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new Entry(data);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, DirectBuffer directBuffer, int n, Object object) {
            if ((n & 1) != 0) {
                directBuffer = entry.data;
            }
            return entry.copy(directBuffer);
        }

        @NotNull
        public String toString() {
            return "Entry(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            return Intrinsics.areEqual((Object)this.data, (Object)entry.data);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/camunda/community/eze/engine/InMemoryLogStorage$ListLogStorageReader;", "Lio/camunda/zeebe/logstreams/storage/LogStorageReader;", "(Lorg/camunda/community/eze/engine/InMemoryLogStorage;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "close", "", "hasNext", "", "next", "Lorg/agrona/DirectBuffer;", "remove", "seek", "position", "", "eze"})
    private final class ListLogStorageReader
    implements LogStorageReader {
        private int currentIndex;

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public void seek(long position) {
            Integer n = Optional.ofNullable(InMemoryLogStorage.this.positionIndexMapping.lowerEntry(position)).map(ListLogStorageReader::seek$lambda$0).map(arg_0 -> ListLogStorageReader.seek$lambda$1(seek.2.INSTANCE, arg_0)).orElse(0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"ofNullable(positionIndex\u2026               .orElse(0)");
            this.currentIndex = ((Number)n).intValue();
        }

        public void close() {
        }

        public void remove() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        public boolean hasNext() {
            return this.currentIndex >= 0 && this.currentIndex < InMemoryLogStorage.this.entries.size();
        }

        @NotNull
        public DirectBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.currentIndex;
            int n = this.currentIndex;
            this.currentIndex = n + 1;
            return ((Entry)InMemoryLogStorage.this.entries.get(index)).getData();
        }

        private static final Integer seek$lambda$0(Map.Entry it) {
            return (Integer)it.getValue();
        }

        private static final Integer seek$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0);
        }
    }
}

